/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.httpbridge.internal;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.servlet.ServletModule;
import javax.inject.Named;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.httpbridge.internal.HttpBridgeServletModule;
import org.sonatype.nexus.security.FilterChainModule;
import org.sonatype.nexus.security.SecurityFilter;

@Named
@FeatureFlag(name="nexus.session.enabled")
public class HttpBridgeModule
extends AbstractModule {
    public static final String MOUNT_POINT = "/repository";
    public static final String DOCKER_V1_MOUNT_POINT = "/v1";
    public static final String DOCKER_V2_MOUNT_POINT = "/v2";

    protected void configure() {
        this.install((Module)new HttpBridgeServletModule(){

            @Override
            protected void bindSecurityFilter(ServletModule.FilterKeyBindingBuilder filter) {
                filter.through(SecurityFilter.class);
            }
        });
        String[] filterChain = new String[]{"nx-authc", "nx-apikey-authc", "nx-anonymous", "nx-anticsrf-authc"};
        this.installFilterChain(filterChain);
    }

    protected void installFilterChain(final String[] filterChain) {
        String[] mountPoints;
        String[] stringArray = mountPoints = new String[]{MOUNT_POINT, DOCKER_V1_MOUNT_POINT, DOCKER_V2_MOUNT_POINT};
        int n = mountPoints.length;
        int n2 = 0;
        while (n2 < n) {
            final String mountPoint = stringArray[n2];
            this.install((Module)new FilterChainModule(){

                protected void configure() {
                    this.addFilterChain(String.valueOf(mountPoint) + "/**", filterChain);
                }
            });
            ++n2;
        }
    }
}

