/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.pypi.internal.orient;

import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.blobstore.restore.pypi.internal.orient.PyPiRestoreBlobData;
import com.sonatype.nexus.blobstore.restore.pypi.internal.orient.PyPiRestoreBlobDataFactory;
import com.sonatype.nexus.repository.pypi.PyPiRestoreUtil;
import com.sonatype.nexus.repository.pypi.orient.PyPiFacet;
import com.sonatype.nexus.repository.pypi.orient.repair.OrientPyPiRepairIndexComponent;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.blobstore.restore.RestoreBlobDataSupport;
import org.sonatype.nexus.blobstore.restore.orient.OrientBaseRestoreBlobStrategy;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="pypi")
@Singleton
public class OrientPyPiRestoreBlobStrategy
extends OrientBaseRestoreBlobStrategy<PyPiRestoreBlobData> {
    private final OrientPyPiRepairIndexComponent pyPiRepairIndexComponent;
    private final PyPiRestoreBlobDataFactory pyPiRestoreBlobDataFactory;

    @Inject
    public OrientPyPiRestoreBlobStrategy(NodeAccess nodeAccess, RepositoryManager repositoryManager, BlobStoreManager blobStoreManager, DryRunPrefix dryRunPrefix, OrientPyPiRepairIndexComponent pyPiRepairIndexComponent, PyPiRestoreBlobDataFactory pyPiRestoreBlobDataFactory) {
        super(nodeAccess, repositoryManager, blobStoreManager, dryRunPrefix);
        this.pyPiRepairIndexComponent = pyPiRepairIndexComponent;
        this.pyPiRestoreBlobDataFactory = pyPiRestoreBlobDataFactory;
    }

    protected PyPiRestoreBlobData createRestoreData(RestoreBlobData blobData) {
        return this.pyPiRestoreBlobDataFactory.create(blobData);
    }

    protected boolean canAttemptRestore(PyPiRestoreBlobData data) {
        Repository repository = data.getBlobData().getRepository();
        if (!repository.optionalFacet(PyPiFacet.class).isPresent()) {
            this.log.warn("Skipping as PyPI Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        return true;
    }

    protected String getAssetPath(PyPiRestoreBlobData data) {
        return data.getBlobData().getBlobName();
    }

    @Transactional
    protected boolean assetExists(PyPiRestoreBlobData data) throws IOException {
        return ((PyPiFacet)data.getBlobData().getRepository().facet(PyPiFacet.class)).assetExists(this.getAssetPath(data));
    }

    @TransactionalStoreMetadata
    protected void createAssetFromBlob(AssetBlob assetBlob, PyPiRestoreBlobData data) throws IOException {
        ((PyPiFacet)data.getBlobData().getRepository().facet(PyPiFacet.class)).put(this.getAssetPath(data), assetBlob);
    }

    protected boolean componentRequired(@Nonnull PyPiRestoreBlobData data) throws IOException {
        return !PyPiRestoreUtil.isIndex((String)this.getAssetPath(data));
    }

    protected Query getComponentQuery(@Nonnull PyPiRestoreBlobData data) {
        return Query.builder().where("name").eq((Object)data.getBlobData().getBlobName()).and("version").eq((Object)data.getVersion()).build();
    }

    protected Repository getRepository(@Nonnull PyPiRestoreBlobData data) {
        return data.getBlobData().getRepository();
    }

    protected boolean shouldDeleteAsset(PyPiRestoreBlobData restoreData, RestoreBlobData blobData, String path) throws IOException {
        return PyPiRestoreUtil.isIndex((String)this.getAssetPath(restoreData)) || super.shouldDeleteAsset((RestoreBlobDataSupport)restoreData, blobData, path);
    }

    public void after(boolean updateAssets, Repository repository) {
        if (updateAssets) {
            this.pyPiRepairIndexComponent.repairRepository(repository);
        } else {
            this.log.info("Updating assets disabled so not running repair of PyPi package metadata");
        }
    }

    protected List<HashAlgorithm> getHashAlgorithms() {
        return ImmutableList.of((Object)HashAlgorithm.SHA1, (Object)HashAlgorithm.SHA256, (Object)HashAlgorithm.MD5);
    }
}

