/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rutauth.internal;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectMethod;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.util.WebUtils;
import org.sonatype.nexus.common.wonderland.AuthTicketService;
import org.sonatype.nexus.extdirect.DirectComponentSupport;
import org.sonatype.nexus.rutauth.internal.RutAuthAuthenticationTokenFactory;
import org.sonatype.nexus.validation.Validate;

@Named
@Singleton
@DirectAction(action={"rut_Auth"})
public class RutAuthComponent
extends DirectComponentSupport {
    private final AuthTicketService authTickets;
    private final RutAuthAuthenticationTokenFactory rutFactory;

    @Inject
    public RutAuthComponent(AuthTicketService authTickets, RutAuthAuthenticationTokenFactory rutFactory) {
        this.authTickets = (AuthTicketService)Preconditions.checkNotNull((Object)authTickets);
        this.rutFactory = (RutAuthAuthenticationTokenFactory)((Object)Preconditions.checkNotNull((Object)((Object)rutFactory)));
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @Validate
    public boolean authenticate() {
        Subject subject = SecurityUtils.getSubject();
        HttpServletRequest request = WebUtils.getHttpRequest((Object)subject);
        HttpServletResponse response = WebUtils.getHttpResponse((Object)subject);
        if (subject == null || request == null || response == null) {
            return false;
        }
        AuthenticationToken token = this.rutFactory.createToken((ServletRequest)request, (ServletResponse)response);
        if (token != null) {
            try {
                SecurityUtils.getSecurityManager().authenticate(token);
                return true;
            }
            catch (AuthenticationException e) {
                this.log.debug("Remote user token authentication failed for subject: " + subject, (Throwable)e);
                return false;
            }
        }
        return false;
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @Validate
    public String authToken() {
        return this.authenticate() ? this.authTickets.createTicket() : null;
    }
}

