/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rutauth.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import org.sonatype.nexus.capability.CapabilityConfigurationSupport;

public class RutAuthCapabilityConfiguration
extends CapabilityConfigurationSupport {
    public static final String HTTP_HEADER = "httpHeader";
    public static final String DEFAULT_HTTP_HEADER = "REMOTE_USER";
    @NotBlank
    private String httpHeader;

    public RutAuthCapabilityConfiguration(Map<String, String> properties) {
        Preconditions.checkNotNull(properties);
        this.httpHeader = properties.get(HTTP_HEADER);
        if (Strings.isNullOrEmpty((String)this.httpHeader)) {
            this.httpHeader = DEFAULT_HTTP_HEADER;
        }
    }

    public String getHttpHeader() {
        return this.httpHeader;
    }

    public RutAuthCapabilityConfiguration withHttpHeader(String httpHeader) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)httpHeader) ? 1 : 0) != 0, (Object)"httpHeader cannot be null or empty");
        this.httpHeader = httpHeader;
        return this;
    }

    public Map<String, String> asMap() {
        HashMap props = Maps.newHashMap();
        props.put(HTTP_HEADER, this.httpHeader);
        return props;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "httpHeader=" + this.httpHeader + "}";
    }
}

