/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.wonderland;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.crypto.RandomBytesGenerator;

@Named
public class AuthTicketGenerator
extends ComponentSupport {
    private static final String CPREFIX = "${wonderland.authTicketGenerator";
    private final RandomBytesGenerator randomBytes;
    private final int defaultSize;

    @Inject
    public AuthTicketGenerator(RandomBytesGenerator randomBytes, @Named(value="${wonderland.authTicketGenerator.defaultSize:-66}") int defaultSize) {
        this.randomBytes = (RandomBytesGenerator)Preconditions.checkNotNull((Object)randomBytes);
        this.defaultSize = defaultSize;
        this.log.debug("Default size: {}", (Object)defaultSize);
    }

    protected String encode(byte[] bytes) {
        return BaseEncoding.base64().encode(bytes);
    }

    public String generate(int size) {
        byte[] bytes = this.randomBytes.generate(size);
        return this.encode(bytes);
    }

    public String generate() {
        return this.generate(this.defaultSize);
    }
}

