/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.wonderland;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Mutex;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.internal.wonderland.UserAuthToken;

@Named
public class AuthTicketCache
extends ComponentSupport {
    private static final String CPREFIX = "${wonderland.authTicketCache";
    private final Mutex lock = new Mutex();
    private final Map<UserAuthToken, Long> tokens = Maps.newHashMap();
    private final Time expireAfter;

    @Inject
    public AuthTicketCache(@Named(value="${wonderland.authTicketCache.expireAfter:-20s}") Time expireAfter) {
        this.expireAfter = (Time)Preconditions.checkNotNull((Object)expireAfter);
        this.log.debug("Expire after: {}", (Object)expireAfter);
    }

    @VisibleForTesting
    public AuthTicketCache() {
        this(Time.seconds((long)2L));
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private void expireTokens() {
        boolean trace = this.log.isTraceEnabled();
        long now = this.now();
        Iterator<Map.Entry<UserAuthToken, Long>> iter = this.tokens.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<UserAuthToken, Long> entry = iter.next();
            if (!this.isTokenExpired(now, entry)) continue;
            iter.remove();
            if (!trace) continue;
            this.log.trace("Expired token: {}", (Object)entry.getKey());
        }
        if (trace && !this.tokens.isEmpty()) {
            this.log.trace("Valid tokens:");
            for (Map.Entry<UserAuthToken, Long> entry : this.tokens.entrySet()) {
                this.log.trace("  {}", (Object)entry.getKey());
            }
        }
    }

    @VisibleForTesting
    protected boolean isTokenExpired(long now, Map.Entry<UserAuthToken, Long> entry) {
        long diff = now - entry.getValue();
        return diff > this.expireAfter.toMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String user, String token) {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            this.expireTokens();
            UserAuthToken key = new UserAuthToken(user, token);
            Preconditions.checkState((!this.tokens.containsKey(key) ? 1 : 0) != 0, (Object)"Duplicate token");
            this.tokens.put(key, this.now());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String user, String token) {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            this.expireTokens();
            Long tmp = this.tokens.remove(new UserAuthToken(user, token));
            return tmp != null;
        }
    }
}

