/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.webresources;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.Mediator;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.internal.webresources.DevModeResources;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.webresources.FileWebResource;
import org.sonatype.nexus.webresources.UrlWebResource;
import org.sonatype.nexus.webresources.WebResource;
import org.sonatype.nexus.webresources.WebResourceBundle;
import org.sonatype.nexus.webresources.WebResourceService;

@Singleton
@Named
public class WebResourceServiceImpl
extends ComponentSupport
implements WebResourceService {
    private final DevModeResources devModeResources;
    private final ServletContext servletContext;
    private final MimeSupport mimeSupport;
    private final Map<String, WebResource> resourcePaths;

    @Inject
    public WebResourceServiceImpl(DevModeResources devModeResources, ServletContext servletContext, MimeSupport mimeSupport) {
        this.devModeResources = (DevModeResources)((Object)Preconditions.checkNotNull((Object)((Object)devModeResources)));
        this.servletContext = (ServletContext)Preconditions.checkNotNull((Object)servletContext);
        this.mimeSupport = (MimeSupport)Preconditions.checkNotNull((Object)mimeSupport);
        this.resourcePaths = Maps.newHashMap();
        List<File> locations = devModeResources.getResourceLocations();
        if (locations != null) {
            this.log.warn("DEV mode resources is ENABLED");
            for (File file : locations) {
                this.log.info("  {}", (Object)file);
            }
        }
    }

    private void addResource(WebResource resource) {
        String path = resource.getPath();
        this.log.trace("Adding resource: {} -> {}", (Object)path, (Object)resource);
        WebResource old = this.resourcePaths.put(path, resource);
        if (old != null) {
            this.log.warn("Overlapping resources on path {}: old={}, new={}", new Object[]{path, old, resource});
        }
    }

    public Collection<String> getPaths() {
        return Collections.unmodifiableCollection(this.resourcePaths.keySet());
    }

    public Collection<WebResource> getResources() {
        return Collections.unmodifiableCollection(this.resourcePaths.values());
    }

    public WebResource getResource(String path) {
        this.log.trace("Looking up resource: {}", (Object)path);
        WebResource resource = null;
        File file = this.devModeResources.getFileIfOnFileSystem(path);
        if (file != null) {
            resource = new FileWebResource(file, path, this.mimeSupport.guessMimeTypeFromPath(file.getName(), new MimeRulesSource[0]), false);
            this.log.trace("Found dev-mode resource: {}", (Object)resource);
        }
        if (resource == null && (resource = this.resourcePaths.get(path)) != null) {
            this.log.trace("Found bound resource: {}", (Object)resource);
        }
        if (resource == null) {
            try {
                URL url = this.servletContext.getResource(path);
                if (url != null && !this.isDirectory(url)) {
                    resource = new UrlWebResource(url, path, this.mimeSupport.guessMimeTypeFromPath(path, new MimeRulesSource[0]));
                    this.log.trace("Found servlet-context resource: {}", (Object)resource);
                }
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return resource;
    }

    private boolean isDirectory(URL url) {
        if ("file".equals(url.getProtocol())) {
            File file = new File(url.getFile());
            return file.isDirectory();
        }
        return false;
    }

    @Named
    static class ResourceBundleMediator
    implements Mediator<Named, WebResourceBundle, WebResourceServiceImpl> {
        ResourceBundleMediator() {
        }

        public void add(BeanEntry<Named, WebResourceBundle> entry, WebResourceServiceImpl watcher) throws Exception {
            List resources = ((WebResourceBundle)entry.getValue()).getResources();
            if (resources != null) {
                for (WebResource resource : resources) {
                    watcher.addResource(resource);
                }
            }
        }

        public void remove(BeanEntry<Named, WebResourceBundle> entry, WebResourceServiceImpl watcher) throws Exception {
        }
    }

    @Named
    static class ResourceMediator
    implements Mediator<Named, WebResource, WebResourceServiceImpl> {
        ResourceMediator() {
        }

        public void add(BeanEntry<Named, WebResource> entry, WebResourceServiceImpl watcher) throws Exception {
            watcher.addResource((WebResource)entry.getValue());
        }

        public void remove(BeanEntry<Named, WebResource> entry, WebResourceServiceImpl watcher) throws Exception {
        }
    }
}

