/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.web;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.template.TemplateHelper;
import org.sonatype.nexus.common.template.TemplateParameters;
import org.sonatype.nexus.common.template.TemplateThrowableAdapter;
import org.sonatype.nexus.servlet.ServletHelper;
import org.sonatype.nexus.servlet.XFrameOptions;

@Named
@Singleton
public class ErrorPageServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ErrorPageServlet.class);
    private static final String TEMPLATE_RESOURCE = "errorPageHtml.vm";
    private static final String ERROR_SERVLET_NAME = "javax.servlet.error.servlet_name";
    private static final String ERROR_REQUEST_URI = "javax.servlet.error.request_uri";
    private static final String ERROR_STATUS_CODE = "javax.servlet.error.status_code";
    private static final String ERROR_MESSAGE = "javax.servlet.error.message";
    private static final String ERROR_EXCEPTION_TYPE = "javax.servlet.error.exception_type";
    private static final String ERROR_EXCEPTION = "javax.servlet.error.exception";
    private final TemplateHelper templateHelper;
    private final XFrameOptions xFrameOptions;
    private final URL template;

    @Inject
    public ErrorPageServlet(TemplateHelper templateHelper, XFrameOptions xFrameOptions) {
        this.templateHelper = (TemplateHelper)Preconditions.checkNotNull((Object)templateHelper);
        this.xFrameOptions = (XFrameOptions)Preconditions.checkNotNull((Object)xFrameOptions);
        this.template = ((Object)((Object)this)).getClass().getResource(TEMPLATE_RESOURCE);
        Preconditions.checkNotNull((Object)this.template);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletHelper.addNoCacheResponseHeaders((HttpServletResponse)response);
        String cfr_ignored_0 = (String)request.getAttribute(ERROR_SERVLET_NAME);
        String cfr_ignored_1 = (String)request.getAttribute(ERROR_REQUEST_URI);
        Integer errorCode = (Integer)request.getAttribute(ERROR_STATUS_CODE);
        String errorMessage = (String)request.getAttribute(ERROR_MESSAGE);
        Class cfr_ignored_2 = (Class)request.getAttribute(ERROR_EXCEPTION_TYPE);
        Throwable cause = (Throwable)request.getAttribute(ERROR_EXCEPTION);
        if (errorCode == null) {
            errorCode = 404;
            errorMessage = "Not found";
        }
        if (errorMessage == null) {
            response.setStatus(errorCode.intValue());
        } else {
            response.setStatus(errorCode.intValue(), errorMessage);
        }
        response.setHeader("X-Frame-Options", this.xFrameOptions.getValueForPath(request.getPathInfo()));
        response.setContentType("text/html");
        String errorDescription = errorMessage != null ? StringEscapeUtils.escapeHtml((String)errorMessage) : "Unknown error";
        TemplateParameters params = this.templateHelper.parameters();
        params.set("errorCode", (Object)errorCode);
        params.set("errorName", (Object)Response.Status.fromStatusCode((int)errorCode).getReasonPhrase());
        params.set("errorDescription", (Object)errorDescription);
        if (cause != null && ServletHelper.isDebug((HttpServletRequest)request)) {
            params.set("errorCause", (Object)new TemplateThrowableAdapter(cause));
        }
        String html = this.templateHelper.render(this.template, params);
        Throwable throwable = null;
        Object var10_11 = null;
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            out.println(html);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static void attachCause(HttpServletRequest request, Throwable cause) {
        if (ErrorPageServlet.isJavaLangError(cause)) {
            log.error("Unexpected exception", Throwables.getRootCause((Throwable)cause));
        } else {
            log.debug("Attaching cause", cause);
        }
        request.setAttribute(ERROR_EXCEPTION_TYPE, cause.getClass());
        request.setAttribute(ERROR_EXCEPTION, (Object)cause);
    }

    private static boolean isJavaLangError(Throwable e) {
        return Throwables.getRootCause((Throwable)e) instanceof Error;
    }
}

