/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.web;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.sisu.Hidden;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.common.app.BaseUrlManager;
import org.sonatype.nexus.security.UserIdMdcHelper;

@Named
@Hidden
@Singleton
public class EnvironmentFilter
extends ComponentSupport
implements Filter {
    private final String serverBanner;
    private final String serverHeader;
    private final BaseUrlManager baseUrlManager;

    @Inject
    public EnvironmentFilter(ApplicationVersion applicationVersion, BaseUrlManager baseUrlManager) {
        Preconditions.checkNotNull((Object)applicationVersion);
        this.serverBanner = String.format("Sonatype Nexus %s %s", applicationVersion.getEdition(), applicationVersion.getVersion());
        this.serverHeader = String.format("Nexus/%s (%s)", applicationVersion.getVersion(), applicationVersion.getEdition());
        this.baseUrlManager = (BaseUrlManager)Preconditions.checkNotNull((Object)baseUrlManager);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        filterConfig.getServletContext().setAttribute("nexus-banner", (Object)this.serverBanner);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        UserIdMdcHelper.unknown();
        this.baseUrlManager.detectAndHoldUrl();
        this.defaultHeaders((HttpServletResponse)response);
        try {
            chain.doFilter(request, response);
        }
        finally {
            UserIdMdcHelper.unset();
        }
    }

    private void defaultHeaders(HttpServletResponse response) {
        response.setHeader("Server", this.serverHeader);
        response.setHeader("X-Content-Type-Options", "nosniff");
    }
}

