/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.template;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.common.app.BaseUrlHolder;
import org.sonatype.nexus.common.template.EscapeHelper;
import org.sonatype.nexus.common.template.TemplateHelper;
import org.sonatype.nexus.common.template.TemplateParameters;

@Named
@Singleton
public class TemplateHelperImpl
extends ComponentSupport
implements TemplateHelper {
    private final ApplicationVersion applicationVersion;
    private final VelocityEngine velocityEngine;

    @Inject
    public TemplateHelperImpl(ApplicationVersion applicationVersion, VelocityEngine velocityEngine) {
        this.applicationVersion = (ApplicationVersion)Preconditions.checkNotNull((Object)applicationVersion);
        this.velocityEngine = (VelocityEngine)Preconditions.checkNotNull((Object)velocityEngine);
    }

    public TemplateParameters parameters() {
        TemplateParameters params = new TemplateParameters();
        params.set("nexusVersion", (Object)this.applicationVersion.getVersion());
        params.set("nexusEdition", (Object)this.applicationVersion.getEdition());
        params.set("nexusBrandedEditionAndVersion", (Object)this.applicationVersion.getBrandedEditionAndVersion());
        params.set("relativePath", (Object)BaseUrlHolder.getRelativePath());
        params.set("urlSuffix", (Object)this.applicationVersion.getVersion());
        params.set("esc", (Object)new EscapeHelper());
        return params;
    }

    public String render(URL template, TemplateParameters parameters) {
        Preconditions.checkNotNull((Object)template);
        Preconditions.checkNotNull((Object)parameters);
        this.log.trace("Rendering template: {} w/params: {}", (Object)template, (Object)parameters);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStreamReader input = new InputStreamReader(template.openStream(), StandardCharsets.UTF_8);){
                StringWriter buff = new StringWriter();
                this.velocityEngine.evaluate((Context)new VelocityContext(parameters.get()), (Writer)buff, template.getFile(), (Reader)input);
                String result = buff.toString();
                this.log.trace("Result: {}", (Object)result);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

