/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.upgrade;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;

@Named
@Singleton
@Upgrades(model="security", from="1.2", to="1.3")
public class SecurityDatabaseUpgrade_1_3
extends DatabaseUpgradeSupport {
    @VisibleForTesting
    static final String DB_CLASS = new OClassNameBuilder().type("privilege").build();
    @VisibleForTesting
    static final String P_PROPERTIES = "properties";
    @VisibleForTesting
    static final String P_ACTIONS = "actions";
    @VisibleForTesting
    static final String P_NAME = "name";
    @VisibleForTesting
    static final String P_TYPE = "type";
    private static final String QUERY = String.format("select from %s where %s = 'application'", DB_CLASS, "type");
    private final Provider<DatabaseInstance> securityDatabaseInstance;

    @Inject
    public SecurityDatabaseUpgrade_1_3(@Named(value="security") Provider<DatabaseInstance> securityDatabaseInstance) {
        this.securityDatabaseInstance = (Provider)Preconditions.checkNotNull(securityDatabaseInstance);
    }

    public void apply() {
        SecurityDatabaseUpgrade_1_3.withDatabaseAndClass(this.securityDatabaseInstance, (String)DB_CLASS, (db, type) -> {
            List results = (List)db.command((OCommandRequest)new OCommandSQL(QUERY)).execute(new Object[0]);
            results.forEach(result -> {
                ArrayList<String> actions;
                String actionString;
                Map properties = (Map)result.field(P_PROPERTIES, OType.EMBEDDEDMAP);
                if (properties != null && (actionString = (String)properties.get(P_ACTIONS)) != null && ((actions = new ArrayList<String>(Arrays.asList(actionString.split(",")))).contains("add") || actions.contains("mark"))) {
                    actions.remove("add");
                    actions.remove("mark");
                    if (!actions.contains("create")) {
                        actions.add("create");
                    }
                    properties.put(P_ACTIONS, String.join((CharSequence)",", actions));
                    result.field(P_PROPERTIES, (Object)properties);
                    this.log.info("Updated application privilege {} to align with CRUD actions", (Object)((String)result.field(P_NAME)));
                    result.save();
                }
            });
        });
    }
}

