/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.realm.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.internal.security.realm.orient.OrientRealmConfiguration;
import org.sonatype.nexus.internal.security.realm.orient.OrientRealmConfigurationEntityAdapter;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.security.realm.RealmConfiguration;
import org.sonatype.nexus.security.realm.RealmConfigurationStore;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientRealmConfigurationStore
extends StateGuardLifecycleSupport
implements RealmConfigurationStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientRealmConfigurationEntityAdapter entityAdapter;

    @Inject
    public OrientRealmConfigurationStore(@Named(value="security") Provider<DatabaseInstance> databaseInstance, OrientRealmConfigurationEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (OrientRealmConfigurationEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    protected void doStart() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public RealmConfiguration newEntity() {
        return this.entityAdapter.newEntity();
    }

    @Nullable
    @Guarded(by={"STARTED"})
    public RealmConfiguration load() {
        return (RealmConfiguration)OrientTransactional.inTx(this.databaseInstance).call(arg_0 -> ((OrientRealmConfigurationEntityAdapter)this.entityAdapter).get(arg_0));
    }

    @Guarded(by={"STARTED"})
    public void save(RealmConfiguration configuration) {
        Preconditions.checkArgument((boolean)(configuration instanceof OrientRealmConfiguration), (Object)"RealmConfiguration does not match backing store");
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            boolean bl = this.entityAdapter.set(db, (Entity)((OrientRealmConfiguration)configuration));
        });
    }
}

