/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.realm.orient;

import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.internal.security.realm.orient.OrientRealmConfiguration;
import org.sonatype.nexus.internal.security.realm.orient.OrientRealmConfigurationCreatedEvent;
import org.sonatype.nexus.internal.security.realm.orient.OrientRealmConfigurationDeletedEvent;
import org.sonatype.nexus.internal.security.realm.orient.OrientRealmConfigurationUpdatedEvent;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.entity.AttachedEntityMetadata;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.SingletonEntityAdapter;

@Named
@Singleton
public class OrientRealmConfigurationEntityAdapter
extends SingletonEntityAdapter<OrientRealmConfiguration> {
    private static final String DB_CLASS = new OClassNameBuilder().type("realm").build();
    private static final String P_REALM_NAMES = "realm_names";

    public OrientRealmConfigurationEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_REALM_NAMES, OType.EMBEDDEDLIST);
    }

    protected OrientRealmConfiguration newEntity() {
        return new OrientRealmConfiguration();
    }

    protected void readFields(ODocument document, OrientRealmConfiguration entity) {
        List realms = (List)document.field(P_REALM_NAMES, OType.EMBEDDEDLIST);
        entity.setRealmNames(realms);
    }

    protected void writeFields(ODocument document, OrientRealmConfiguration entity) {
        document.field(P_REALM_NAMES, entity.getRealmNames());
    }

    public EntityEvent newEvent(ODocument document, EntityAdapter.EventKind eventKind) {
        AttachedEntityMetadata metadata = new AttachedEntityMetadata((EntityAdapter)this, document);
        this.log.debug("Emitted {} event with metadata {}", (Object)eventKind, (Object)metadata);
        switch (eventKind) {
            case CREATE: {
                return new OrientRealmConfigurationCreatedEvent((EntityMetadata)metadata);
            }
            case UPDATE: {
                return new OrientRealmConfigurationUpdatedEvent((EntityMetadata)metadata);
            }
            case DELETE: {
                return new OrientRealmConfigurationDeletedEvent((EntityMetadata)metadata);
            }
        }
        return null;
    }
}

