/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.model.orient;

import com.google.common.collect.Sets;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.internal.security.model.orient.OrientCUserRoleMapping;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.DeleteEntityByPropertyAction;
import org.sonatype.nexus.orient.entity.action.ReadEntityByPropertyAction;
import org.sonatype.nexus.orient.entity.action.UpdateEntityByPropertyAction;
import org.sonatype.nexus.security.config.SecuritySourceUtil;

@Named
@Singleton
public class OrientCUserRoleMappingEntityAdapter
extends IterableEntityAdapter<OrientCUserRoleMapping> {
    private static final String DB_CLASS = new OClassNameBuilder().type("user_role_mapping").build();
    private static final String P_USER_ID = "userId";
    private static final String P_USER_ID_LOWERCASE = "userId.toLowerCase()";
    private static final String P_SOURCE = "source";
    private static final String P_ROLES = "roles";
    private static final String I_USER_ID_SOURCE = new OIndexNameBuilder().type(DB_CLASS).property("userId").property("source").build();
    private final ReadEntityByPropertyAction<OrientCUserRoleMapping> read = new ReadEntityByPropertyAction((EntityAdapter)this, new String[]{"userId", "source"});
    private final ReadEntityByPropertyAction<OrientCUserRoleMapping> readIgnoreCase = new ReadEntityByPropertyAction((EntityAdapter)this, new String[]{"userId.toLowerCase()", "source"});
    private final DeleteEntityByPropertyAction delete = new DeleteEntityByPropertyAction((EntityAdapter)this, new String[]{"userId", "source"});
    private final DeleteEntityByPropertyAction deleteIgnoreCase = new DeleteEntityByPropertyAction((EntityAdapter)this, new String[]{"userId.toLowerCase()", "source"});
    private final UpdateEntityByPropertyAction<OrientCUserRoleMapping> update = new UpdateEntityByPropertyAction((EntityAdapter)this, new String[]{"userId", "source"});
    private final UpdateEntityByPropertyAction<OrientCUserRoleMapping> updateIgnoreCase = new UpdateEntityByPropertyAction((EntityAdapter)this, new String[]{"userId.toLowerCase()", "source"});

    public OrientCUserRoleMappingEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_USER_ID, OType.STRING).setNotNull(true);
        type.createProperty(P_SOURCE, OType.STRING).setNotNull(true);
        type.createProperty(P_ROLES, OType.EMBEDDEDSET);
        type.createIndex(I_USER_ID_SOURCE, OClass.INDEX_TYPE.UNIQUE, new String[]{P_USER_ID, P_SOURCE});
    }

    protected OrientCUserRoleMapping newEntity() {
        return new OrientCUserRoleMapping();
    }

    protected void readFields(ODocument document, OrientCUserRoleMapping entity) throws Exception {
        entity.setUserId((String)document.field(P_USER_ID, OType.STRING));
        entity.setSource((String)document.field(P_SOURCE, OType.STRING));
        entity.setRoles(Sets.newHashSet((Iterable)((Iterable)document.field(P_ROLES, OType.EMBEDDEDSET))));
        entity.setVersion(String.valueOf(document.getVersion()));
    }

    protected void writeFields(ODocument document, OrientCUserRoleMapping entity) throws Exception {
        document.field(P_USER_ID, (Object)entity.getUserId());
        document.field(P_SOURCE, (Object)entity.getSource());
        document.field(P_ROLES, entity.getRoles());
    }

    @Nullable
    public OrientCUserRoleMapping read(ODatabaseDocumentTx db, String userId, String source) {
        return SecuritySourceUtil.isCaseInsensitiveSource((String)source) ? (OrientCUserRoleMapping)this.readIgnoreCase.execute(db, new Object[]{userId.toLowerCase(), source}) : (OrientCUserRoleMapping)this.read.execute(db, new Object[]{userId, source});
    }

    public boolean delete(ODatabaseDocumentTx db, String userId, String source) {
        return SecuritySourceUtil.isCaseInsensitiveSource((String)source) ? this.deleteIgnoreCase.execute(db, new Object[]{userId.toLowerCase(), source}) : this.delete.execute(db, new Object[]{userId, source});
    }

    public boolean update(ODatabaseDocumentTx db, OrientCUserRoleMapping entity) {
        return SecuritySourceUtil.isCaseInsensitiveSource((String)entity.getSource()) ? this.updateIgnoreCase.execute(db, (Entity)entity, new Object[]{entity.getUserId().toLowerCase(), entity.getSource()}) : this.update.execute(db, (Entity)entity, new Object[]{entity.getUserId(), entity.getSource()});
    }
}

