/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.internal.security.model.CUserData;
import org.sonatype.nexus.internal.security.model.CUserRoleMappingData;
import org.sonatype.nexus.security.config.CUser;
import org.sonatype.nexus.security.config.CUserRoleMapping;
import org.sonatype.nexus.security.config.SecurityConfiguration;
import org.sonatype.nexus.supportzip.ExportSecurityData;
import org.sonatype.nexus.supportzip.ImportData;
import org.sonatype.nexus.supportzip.datastore.JsonExporter;

@Named(value="securityUserExport")
@Singleton
public class SecurityUserExport
extends JsonExporter
implements ExportSecurityData,
ImportData {
    private final SecurityConfiguration configuration;

    @Inject
    public SecurityUserExport(SecurityConfiguration configuration) {
        this.configuration = configuration;
    }

    public void export(File file) throws IOException {
        this.log.debug("Export CUser and CUserRoleMapping data to {}", (Object)file);
        Map userIdToCUser = this.configuration.getUsers().stream().collect(Collectors.toMap(CUser::getId, Function.identity()));
        List userRoleMappings = this.configuration.getUserRoleMappings();
        ArrayList<SecurityUserData> securityUsers = new ArrayList<SecurityUserData>(userIdToCUser.size());
        for (Map.Entry userEntry : userIdToCUser.entrySet()) {
            List<CUserRoleMapping> roleMappings = userRoleMappings.stream().filter(user -> user.getUserId().equals(userEntry.getKey())).collect(Collectors.toList());
            SecurityUserData securityUserData = new SecurityUserData();
            securityUserData.setUser((CUser)userEntry.getValue());
            securityUserData.setUserRoleMappings(roleMappings);
            securityUsers.add(securityUserData);
        }
        this.exportToJson(securityUsers, file);
    }

    public void restore(File file) throws IOException {
        this.log.debug("Restoring CUser and CUserRoleMapping data from {}", (Object)file);
        List securityUsers = this.importFromJson(file, SecurityUserData.class);
        for (SecurityUserData securityUser : securityUsers) {
            this.configuration.addUser(securityUser.user, securityUser.getRoles());
        }
    }

    public static class SecurityUserData {
        @JsonProperty
        @JsonDeserialize(as=CUserData.class)
        private CUser user;
        @JsonProperty
        @JsonDeserialize(contentAs=CUserRoleMappingData.class)
        private List<CUserRoleMapping> userRoleMappings;

        public CUser getUser() {
            return this.user;
        }

        public void setUser(CUser user) {
            this.user = user;
        }

        public List<CUserRoleMapping> getUserRoleMappings() {
            return this.userRoleMappings;
        }

        public void setUserRoleMappings(List<CUserRoleMapping> userRoleMappings) {
            this.userRoleMappings = userRoleMappings;
        }

        @JsonIgnore
        public Set<String> getRoles() {
            return this.userRoleMappings.stream().filter(role -> "default".equals(role.getSource())).findFirst().map(CUserRoleMapping::getRoles).orElse(Collections.emptySet());
        }
    }
}

