/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.model;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.internal.security.model.SecurityConfigurationImpl;
import org.sonatype.nexus.security.config.CPrivilege;
import org.sonatype.nexus.security.config.CRole;
import org.sonatype.nexus.security.config.CUser;
import org.sonatype.nexus.security.config.CUserRoleMapping;
import org.sonatype.nexus.security.config.SecurityConfiguration;
import org.sonatype.nexus.security.config.SecurityConfigurationSource;

@Named(value="default")
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@FeatureFlag(name="nexus.datastore.enabled")
@Singleton
public class SecurityConfigurationSourceImpl
extends StateGuardLifecycleSupport
implements SecurityConfigurationSource {
    private SecurityConfigurationImpl securityConfiguration;
    private SecurityConfigurationSource securityDefaults;

    @Inject
    public SecurityConfigurationSourceImpl(SecurityConfigurationImpl securityConfiguration, @Named(value="static") SecurityConfigurationSource securityDefaults) {
        this.securityConfiguration = (SecurityConfigurationImpl)((Object)Preconditions.checkNotNull((Object)((Object)securityConfiguration)));
        this.securityDefaults = (SecurityConfigurationSource)Preconditions.checkNotNull((Object)securityDefaults);
    }

    protected void doStart() throws Exception {
        if (!SystemPropertiesHelper.getBoolean((String)"nexus.orient.enabled", (boolean)true)) {
            this.addDefaultUsers();
            this.addDefaultRoles();
            this.addDefaultPrivileges();
            this.addDefaultUserRoleMappings();
        }
    }

    private void addDefaultUsers() {
        this.log.info("Initializing default users");
        for (CUser user : this.securityDefaults.getConfiguration().getUsers()) {
            if (this.securityConfiguration.getUser(user.getId()) != null) continue;
            this.securityConfiguration.addUser(user);
        }
    }

    private void addDefaultRoles() {
        this.log.info("Initializing default roles");
        for (CRole role : this.securityDefaults.getConfiguration().getRoles()) {
            if (this.securityConfiguration.getRole(role.getId()) != null) continue;
            this.securityConfiguration.addRole(role);
        }
    }

    private void addDefaultPrivileges() {
        this.log.info("Initializing default privileges");
        for (CPrivilege privilege : this.securityDefaults.getConfiguration().getPrivileges()) {
            if (this.securityConfiguration.getPrivilege(privilege.getId()) != null) continue;
            this.securityConfiguration.addPrivilege(privilege);
        }
    }

    private void addDefaultUserRoleMappings() {
        this.log.info("Initializing default user/role mappings");
        for (CUserRoleMapping mapping : this.securityDefaults.getConfiguration().getUserRoleMappings()) {
            if (this.securityConfiguration.getUserRoleMapping(mapping.getUserId(), mapping.getSource()) != null) continue;
            this.securityConfiguration.addUserRoleMapping(mapping);
        }
    }

    public SecurityConfiguration getConfiguration() {
        return this.securityConfiguration;
    }

    public SecurityConfiguration loadConfiguration() {
        return this.securityConfiguration;
    }
}

