/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.model;

import com.google.common.collect.Maps;
import java.util.Map;
import org.sonatype.nexus.common.entity.HasStringId;
import org.sonatype.nexus.security.config.CPrivilege;

public class CPrivilegeData
implements HasStringId,
CPrivilege {
    private String description;
    private String id;
    private String name;
    private Map<String, String> properties;
    private boolean readOnly = false;
    private String type;
    private int version = 1;

    public CPrivilegeData clone() {
        try {
            CPrivilegeData copy = (CPrivilegeData)super.clone();
            if (this.properties != null) {
                copy.properties = Maps.newHashMap(this.properties);
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = Maps.newHashMap();
        }
        return this.properties;
    }

    public String getProperty(String key) {
        return this.getProperties().get(key);
    }

    public String getType() {
        return this.type;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void removeProperty(String key) {
        this.getProperties().remove(key);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setProperty(String key, String value) {
        this.getProperties().put(key, value);
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setVersion(int version) {
        this.version = Math.max(version, 1);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", type='" + this.type + '\'' + ", properties=" + this.properties + ", readOnly=" + this.readOnly + ", version='" + this.version + '\'' + '}';
    }
}

