/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.jaas;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.security.SecuritySystem;
import org.sonatype.nexus.security.role.RoleIdentifier;
import org.sonatype.nexus.security.user.User;
import org.sonatype.nexus.security.user.UserNotFoundException;

public class ShiroLoginModule
extends ComponentSupport
implements LoginModule {
    private final Set<Principal> principals = new HashSet<Principal>();
    private Subject jaasSubject;
    private CallbackHandler callbackHandler;
    private SecurityHelper securityHelper;
    private SecuritySystem securitySystem;
    private User user;

    @Override
    public void initialize(Subject jaasSubject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.jaasSubject = (Subject)Preconditions.checkNotNull((Object)jaasSubject);
        this.callbackHandler = (CallbackHandler)Preconditions.checkNotNull((Object)callbackHandler);
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull(options.get(SecurityHelper.class.getName()));
        this.securitySystem = (SecuritySystem)Preconditions.checkNotNull(options.get(SecuritySystem.class.getName()));
    }

    @Override
    public boolean login() throws LoginException {
        block9: {
            Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (IOException | UnsupportedCallbackException e) {
                this.log.debug("Missing credentials", (Throwable)e);
                throw new LoginException(e.getMessage());
            }
            org.apache.shiro.subject.Subject shiroSubject = this.securityHelper.subject();
            Preconditions.checkState((shiroSubject != null ? 1 : 0) != 0);
            try {
                try {
                    shiroSubject.login((AuthenticationToken)new UsernamePasswordToken(((NameCallback)callbacks[0]).getName(), ((PasswordCallback)callbacks[1]).getPassword()));
                    if (!shiroSubject.hasRole("nx-anonymous")) {
                        this.user = this.securitySystem.getUser(shiroSubject.getPrincipal().toString());
                        break block9;
                    }
                    throw new LoginException("Invalid username or password");
                }
                catch (AuthenticationException | UserNotFoundException e) {
                    this.log.debug("Authentication failed", e);
                    throw new LoginException("Invalid username or password");
                }
            }
            finally {
                if (this.user == null) {
                    shiroSubject.logout();
                }
            }
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.user != null) {
            this.principals.add((Principal)new UserPrincipal(this.user.getUserId()));
            for (RoleIdentifier role : this.user.getRoles()) {
                String roleId = role.getRoleId();
                if ("nx-admin".equals(roleId)) {
                    this.principals.add((Principal)new RolePrincipal("admin"));
                    this.principals.add((Principal)new RolePrincipal("manager"));
                    this.principals.add((Principal)new RolePrincipal("viewer"));
                    continue;
                }
                if (!roleId.startsWith("karaf-")) continue;
                this.principals.add((Principal)new RolePrincipal(roleId.substring(6)));
            }
            this.jaasSubject.getPrincipals().addAll(this.principals);
            return true;
        }
        return this.clearState();
    }

    @Override
    public boolean abort() throws LoginException {
        return this.clearState();
    }

    @Override
    public boolean logout() throws LoginException {
        return this.clearState();
    }

    private boolean clearState() {
        if (this.user != null) {
            this.jaasSubject.getPrincipals().removeAll(this.principals);
            this.principals.clear();
            this.user = null;
            this.securityHelper.subject().logout();
            return true;
        }
        return false;
    }
}

