/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.anonymous.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.internal.security.anonymous.AnonymousConfigurationStore;
import org.sonatype.nexus.internal.security.anonymous.orient.OrientAnonymousConfiguration;
import org.sonatype.nexus.internal.security.anonymous.orient.OrientAnonymousConfigurationEntityAdapter;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.security.anonymous.AnonymousConfiguration;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientAnonymousConfigurationStore
extends StateGuardLifecycleSupport
implements AnonymousConfigurationStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientAnonymousConfigurationEntityAdapter entityAdapter;

    @Inject
    public OrientAnonymousConfigurationStore(@Named(value="security") Provider<DatabaseInstance> databaseInstance, OrientAnonymousConfigurationEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (OrientAnonymousConfigurationEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    protected void doStart() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Nullable
    @Guarded(by={"STARTED"})
    public AnonymousConfiguration load() {
        return (AnonymousConfiguration)OrientTransactional.inTx(this.databaseInstance).call(arg_0 -> ((OrientAnonymousConfigurationEntityAdapter)this.entityAdapter).get(arg_0));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void save(AnonymousConfiguration configuration) {
        Preconditions.checkArgument((boolean)(configuration instanceof OrientAnonymousConfiguration), (Object)"Anonymous configuration does not match backing store");
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            boolean bl = this.entityAdapter.set(db, (Entity)((OrientAnonymousConfiguration)configuration));
        });
    }

    @Override
    public AnonymousConfiguration newConfiguration() {
        return new OrientAnonymousConfiguration();
    }
}

