/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.anonymous;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Mutex;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventConsumer;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.internal.security.anonymous.AnonymousConfigurationEvent;
import org.sonatype.nexus.internal.security.anonymous.AnonymousConfigurationStore;
import org.sonatype.nexus.jmx.reflect.ManagedAttribute;
import org.sonatype.nexus.jmx.reflect.ManagedObject;
import org.sonatype.nexus.security.anonymous.AnonymousConfiguration;
import org.sonatype.nexus.security.anonymous.AnonymousConfigurationChangedEvent;
import org.sonatype.nexus.security.anonymous.AnonymousManager;
import org.sonatype.nexus.security.anonymous.AnonymousPrincipalCollection;

@Named
@Singleton
@ManagedObject
public class AnonymousManagerImpl
extends ComponentSupport
implements AnonymousManager,
EventAware {
    private final EventManager eventManager;
    private final AnonymousConfigurationStore store;
    private final Provider<AnonymousConfiguration> defaults;
    private final Mutex lock = new Mutex();
    private AnonymousConfiguration configuration;

    @Inject
    public AnonymousManagerImpl(EventManager eventManager, AnonymousConfigurationStore store, @Named(value="initial") Provider<AnonymousConfiguration> defaults) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.store = (AnonymousConfigurationStore)Preconditions.checkNotNull((Object)store);
        this.log.debug("Store: {}", (Object)store);
        this.defaults = (Provider)Preconditions.checkNotNull(defaults);
        this.log.debug("Defaults: {}", defaults);
    }

    public boolean isConfigured() {
        return this.store.load() != null;
    }

    private AnonymousConfiguration loadConfiguration() {
        AnonymousConfiguration model = this.store.load();
        if (model == null) {
            AnonymousConfiguration defaultModel = (AnonymousConfiguration)this.defaults.get();
            Preconditions.checkNotNull((Object)defaultModel);
            model = this.store.newConfiguration();
            model.setEnabled(defaultModel.isEnabled());
            model.setRealmName(defaultModel.getRealmName());
            model.setUserId(defaultModel.getUserId());
            this.log.info("Using default configuration: {}", (Object)model);
        } else {
            this.log.info("Loaded configuration: {}", (Object)model);
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnonymousConfiguration getConfigurationInternal() {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            if (this.configuration == null) {
                this.configuration = this.loadConfiguration();
            }
            return this.configuration;
        }
    }

    public AnonymousConfiguration getConfiguration() {
        return this.getConfigurationInternal().copy();
    }

    public AnonymousConfiguration newConfiguration() {
        return this.store.newConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfiguration(AnonymousConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        AnonymousConfiguration model = configuration.copy();
        this.log.info("Saving configuration: {}", (Object)model);
        Mutex mutex = this.lock;
        synchronized (mutex) {
            if (!EventHelper.isReplicating()) {
                this.store.save(model);
            }
            this.configuration = model;
        }
        this.eventManager.post((Object)new AnonymousConfigurationChangedEvent(model));
    }

    @ManagedAttribute
    public boolean isEnabled() {
        return this.getConfigurationInternal().isEnabled();
    }

    public Subject buildSubject() {
        AnonymousConfiguration model = this.getConfigurationInternal();
        this.log.trace("Building anonymous subject with user-id: {}, realm-name: {}", (Object)model.getUserId(), (Object)model.getRealmName());
        AnonymousPrincipalCollection principals = new AnonymousPrincipalCollection((Object)model.getUserId(), model.getRealmName());
        return new Subject.Builder().principals((PrincipalCollection)principals).authenticated(false).sessionCreationEnabled(false).buildSubject();
    }

    @Subscribe
    public void onStoreChanged(AnonymousConfigurationEvent event) {
        this.handleReplication(event, (EventConsumer<AnonymousConfigurationEvent>)((EventConsumer)e -> this.setConfiguration(e.getAnonymousConfiguration())));
    }

    private void handleReplication(AnonymousConfigurationEvent event, EventConsumer<AnonymousConfigurationEvent> consumer) {
        if (!event.isLocal()) {
            try {
                consumer.accept((Object)event);
            }
            catch (Exception e) {
                this.log.error("Failed to replicate: {}", (Object)event, (Object)e);
            }
        }
    }
}

