/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.anonymous;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.internal.security.anonymous.AnonymousConfigurationData;
import org.sonatype.nexus.internal.security.anonymous.AnonymousConfigurationStore;
import org.sonatype.nexus.security.anonymous.AnonymousConfiguration;
import org.sonatype.nexus.supportzip.ExportSecurityData;
import org.sonatype.nexus.supportzip.ImportData;
import org.sonatype.nexus.supportzip.datastore.JsonExporter;

@Named(value="anonymousConfigurationExport")
@Singleton
public class AnonymousConfigurationExport
extends JsonExporter
implements ExportSecurityData,
ImportData {
    private final AnonymousConfigurationStore anonymousConfigurationStore;

    @Inject
    public AnonymousConfigurationExport(AnonymousConfigurationStore anonymousConfigurationStore) {
        this.anonymousConfigurationStore = anonymousConfigurationStore;
    }

    public void export(File file) throws IOException {
        this.log.debug("Export AnonymousConfiguration data to {}", (Object)file);
        AnonymousConfiguration configuration = this.anonymousConfigurationStore.load();
        this.exportObjectToJson(configuration, file);
    }

    public void restore(File file) throws IOException {
        this.log.debug("Restoring AnonymousConfiguration data from {}", (Object)file);
        Optional configuration = this.importObjectFromJson(file, AnonymousConfigurationData.class);
        configuration.ifPresent(this.anonymousConfigurationStore::save);
    }
}

