/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.rest;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FreezeService;
import org.sonatype.nexus.common.app.ReadOnlyState;
import org.sonatype.nexus.internal.rest.FreezeResourceDoc;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.security.privilege.ApplicationPermission;

@Named
@Singleton
@Path(value="/v1/read-only")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class FreezeResource
extends ComponentSupport
implements Resource,
FreezeResourceDoc {
    public static final String RESOURCE_URI = "/v1/read-only";
    private static final String ENABLE_READONLY_FAILED_MESSAGE = "Attempt to enable read-only failed";
    private static final String RELESE_READONLY_FAILED_MESSAGE = "Attempt to release read-only failed";
    private static final String FORCE_RELEASE_READONLY_FAILED_MESSAGE = "Attempt to force release read-only failed";
    private static final Permission READ_SETTINGS_PERMISSION = new ApplicationPermission("settings", Arrays.asList("read"));
    private final FreezeService freezeService;
    private final SecurityHelper securityHelper;

    @Inject
    public FreezeResource(FreezeService freezeService, SecurityHelper securityHelper) {
        this.freezeService = (FreezeService)Preconditions.checkNotNull((Object)freezeService);
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
    }

    @Override
    @RequiresUser
    @GET
    public ReadOnlyState get() {
        return new ReadOnlyState(this.freezeService.currentFreezeRequests(), this.securityHelper.allPermitted(new Permission[]{READ_SETTINGS_PERMISSION}));
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    @POST
    @Path(value="/freeze")
    public void freeze() {
        try {
            this.freezeService.requestFreeze("REST request");
        }
        catch (Exception e) {
            this.log.warn(ENABLE_READONLY_FAILED_MESSAGE, (Throwable)e);
            throw new WebApplicationException(ENABLE_READONLY_FAILED_MESSAGE, 404);
        }
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    @POST
    @Path(value="/release")
    public void release() {
        try {
            this.freezeService.cancelFreeze();
        }
        catch (Exception e) {
            this.log.warn(RELESE_READONLY_FAILED_MESSAGE, (Throwable)e);
            throw new WebApplicationException(RELESE_READONLY_FAILED_MESSAGE, 404);
        }
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    @POST
    @Path(value="/force-release")
    public void forceRelease() {
        try {
            this.freezeService.cancelAllFreezeRequests();
        }
        catch (Exception e) {
            this.log.warn(FORCE_RELEASE_READONLY_FAILED_MESSAGE, (Throwable)e);
            throw new WebApplicationException(FORCE_RELEASE_READONLY_FAILED_MESSAGE, 404);
        }
    }
}

