/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.orient;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.transaction.RetryController;

@Named(value="Transactions")
@Singleton
public class TransactionHealthCheck
extends HealthCheck {
    private final RetryController retryController;

    @Inject
    public TransactionHealthCheck(RetryController retryController) {
        this.retryController = (RetryController)Preconditions.checkNotNull((Object)retryController);
    }

    protected HealthCheck.Result check() {
        long excessiveRetriesInLastHour = this.retryController.excessiveRetriesInLastHour();
        if (excessiveRetriesInLastHour > 0L) {
            return HealthCheck.Result.unhealthy((String)"%d transaction%s with excessive retries in last hour", (Object[])new Object[]{excessiveRetriesInLastHour, excessiveRetriesInLastHour == 1L ? "" : "s"});
        }
        return HealthCheck.Result.healthy();
    }
}

