/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.orient;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.internal.orient.PasswordSanitizedJsonSource;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseManager;
import org.sonatype.nexus.supportzip.SupportBundle;
import org.sonatype.nexus.supportzip.SupportBundleCustomizer;

public class SecurityDatabase {
    public static final String NAME = "security";

    private SecurityDatabase() {
    }

    @FeatureFlag(name="nexus.orient.enabled")
    @Named(value="security")
    @Singleton
    public static class ProviderImpl
    implements Provider<DatabaseInstance> {
        private final DatabaseManager databaseManager;

        @Inject
        public ProviderImpl(DatabaseManager databaseManager) {
            this.databaseManager = (DatabaseManager)Preconditions.checkNotNull((Object)databaseManager);
        }

        public DatabaseInstance get() {
            return this.databaseManager.instance(SecurityDatabase.NAME);
        }
    }

    @FeatureFlag(name="nexus.orient.enabled")
    @Named
    @Singleton
    public static class SupportBundleCustomizerImpl
    extends ComponentSupport
    implements SupportBundleCustomizer {
        private final Provider<DatabaseInstance> databaseInstance;

        @Inject
        public SupportBundleCustomizerImpl(@Named(value="security") Provider<DatabaseInstance> databaseInstance) {
            this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        }

        public void customize(SupportBundle supportBundle) {
            String path = String.format("work/%s/%s/%s", "db", ((DatabaseInstance)this.databaseInstance.get()).getName(), "export.json");
            supportBundle.add((SupportBundle.ContentSource)new PasswordSanitizedJsonSource(SupportBundle.ContentSource.Type.SECURITY, path, this.databaseInstance));
        }
    }
}

