/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerCommandConfiguration;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.config.OServerHandlerConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkListenerConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkProtocolConfiguration;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.config.OServerSecurityConfiguration;
import com.orientechnologies.orient.server.config.OServerStorageConfiguration;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import com.orientechnologies.orient.server.network.protocol.http.ONetworkProtocolHttpDb;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetStaticContent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.log.LoggerLevelChangedEvent;
import org.sonatype.nexus.common.log.LoggersResetEvent;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.jmx.reflect.ManagedAttribute;
import org.sonatype.nexus.jmx.reflect.ManagedObject;
import org.sonatype.nexus.orient.DatabaseInstanceNames;
import org.sonatype.nexus.orient.DatabaseServer;
import org.sonatype.nexus.orient.OrientConfigCustomizer;
import org.sonatype.nexus.orient.entity.EntityHook;

@Named
@Singleton
@ManagedObject
public class DatabaseServerImpl
extends StateGuardLifecycleSupport
implements DatabaseServer,
EventAware,
EventAware.Asynchronous {
    private static final String JUL_ROOT_LOGGER = "";
    private static final String ORIENTDB_PARENT_LOGGER = "com";
    private static final String ORIENTDB_LOGGER = "com.orientechnologies";
    private final ApplicationDirectories applicationDirectories;
    private final File databasesDir;
    private final List<OServerHandlerConfiguration> injectedHandlers;
    private final List<OrientConfigCustomizer> configCustomizers;
    private final EntityHook entityHook;
    private final ClassLoader uberClassLoader;
    private final boolean binaryListenerEnabled;
    private final boolean httpListenerEnabled;
    private boolean dynamicPlugins;
    private final String binaryPortRange;
    private final String httpPortRange;
    private final int binaryMaxLengthKB;
    private OServer orientServer;

    @Inject
    public DatabaseServerImpl(ApplicationDirectories applicationDirectories, List<OServerHandlerConfiguration> injectedHandlers, List<OrientConfigCustomizer> configCustomizers, @Named(value="nexus-uber") ClassLoader uberClassLoader, @Named(value="${nexus.orient.binaryListenerEnabled:-false}") boolean binaryListenerEnabled, @Named(value="${nexus.orient.httpListenerEnabled:-false}") boolean httpListenerEnabled, @Named(value="${nexus.orient.dynamicPlugins:-false}") boolean dynamicPlugins, @Named(value="${nexus.orient.binaryListener.portRange:-2424-2430}") String binaryPortRange, @Named(value="${nexus.orient.httpListener.portRange:-2480-2490}") String httpPortRange, @Named(value="${nexus.orient.network.binary.maxLengthKB:-0}") int binaryMaxLengthKB, NodeAccess nodeAccess, EntityHook entityHook) {
        this.applicationDirectories = (ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories);
        this.injectedHandlers = (List)Preconditions.checkNotNull(injectedHandlers);
        this.configCustomizers = (List)Preconditions.checkNotNull(configCustomizers);
        this.uberClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)uberClassLoader);
        this.httpListenerEnabled = httpListenerEnabled;
        this.dynamicPlugins = dynamicPlugins;
        this.binaryPortRange = binaryPortRange;
        this.httpPortRange = httpPortRange;
        this.entityHook = (EntityHook)Preconditions.checkNotNull((Object)entityHook);
        Preconditions.checkArgument((binaryMaxLengthKB >= 0 ? 1 : 0) != 0, (Object)"Must specify a non-negative integer");
        this.binaryMaxLengthKB = binaryMaxLengthKB;
        this.binaryListenerEnabled = nodeAccess.isClustered() ? true : binaryListenerEnabled;
        this.databasesDir = applicationDirectories.getWorkDirectory("db");
        this.log.info("OrientDB version: {}", (Object)OConstants.getVersion());
    }

    @ManagedAttribute
    public boolean isBinaryListenerEnabled() {
        return this.binaryListenerEnabled;
    }

    @ManagedAttribute
    public boolean isHttpListenerEnabled() {
        return this.httpListenerEnabled;
    }

    protected void doStart() throws Exception {
        Orient.instance().startup();
        OServer server = new OServer(false){

            public Map<String, String> getAvailableStorageNames() {
                return DatabaseServerImpl.this.getExistingDatabaseUrls();
            }
        };
        this.configureOrientMinimumLogLevel();
        server.setExtensionClassLoader(this.uberClassLoader);
        OServerConfiguration config = this.createConfiguration();
        server.startup(config);
        Orient.instance().removeShutdownHook();
        server.removeShutdownHook();
        server.addUser("root", null, "*");
        if (this.log.isDebugEnabled()) {
            String encoding = StandardCharsets.UTF_8.name();
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            OGlobalConfiguration.dumpConfiguration((PrintStream)new PrintStream((OutputStream)buff, true, encoding));
            this.log.debug("Global configuration:\n{}", (Object)new String(buff.toByteArray(), encoding));
        }
        Orient.instance().addDbLifecycleListener((ODatabaseLifecycleListener)this.entityHook);
        server.activate();
        this.log.info("Activated");
        this.orientServer = server;
    }

    private Map<String, String> getExistingDatabaseUrls() {
        return (Map)DatabaseInstanceNames.DATABASE_NAMES.stream().filter(this::databaseExists).collect(ImmutableMap.toImmutableMap(Function.identity(), this::resolveDatabaseUrl));
    }

    private boolean databaseExists(String name) {
        return new File(this.resolveDatabaseDir(name), "database.ocf").exists();
    }

    private String resolveDatabaseUrl(String name) {
        return "plocal:" + this.resolveDatabaseDir(name).getAbsolutePath();
    }

    private File resolveDatabaseDir(String name) {
        return new File(this.databasesDir, name);
    }

    private OServerConfiguration createConfiguration() {
        File configDir = this.applicationDirectories.getConfigDirectory("fabric");
        File orientDir = this.applicationDirectories.getWorkDirectory("orient");
        System.setProperty("orient.home", orientDir.getPath());
        System.setProperty("ORIENTDB_HOME", orientDir.getPath());
        OServerConfiguration config = new OServerConfiguration();
        config.location = "DYNAMIC-CONFIGURATION";
        File securityFile = new File(configDir, "orientdb-security.json");
        config.properties = new OServerEntryConfiguration[]{new OServerEntryConfiguration("server.database.path", this.databasesDir.getPath()), new OServerEntryConfiguration("server.security.file", securityFile.getPath()), new OServerEntryConfiguration("plugin.dynamic", String.valueOf(this.dynamicPlugins))};
        config.handlers = new ArrayList<OServerHandlerConfiguration>(this.injectedHandlers);
        config.hooks = new ArrayList();
        config.network = new OServerNetworkConfiguration();
        config.network.protocols = Lists.newArrayList((Object[])new OServerNetworkProtocolConfiguration[]{new OServerNetworkProtocolConfiguration("binary", ONetworkProtocolBinary.class.getName()), new OServerNetworkProtocolConfiguration("http", ONetworkProtocolHttpDb.class.getName())});
        config.network.listeners = new ArrayList();
        OServerNetworkListenerConfiguration binaryListener = null;
        OServerNetworkListenerConfiguration httpListener = null;
        if (this.binaryListenerEnabled) {
            binaryListener = this.createBinaryListener(this.binaryPortRange);
            config.network.listeners.add(binaryListener);
        }
        if (this.httpListenerEnabled) {
            httpListener = this.createHttpListener(this.httpPortRange);
            config.network.listeners.add(httpListener);
        }
        config.storages = new OServerStorageConfiguration[0];
        config.users = new OServerUserConfiguration[]{new OServerUserConfiguration("admin", "admin", "*")};
        config.security = new OServerSecurityConfiguration();
        config.security.users = new ArrayList();
        config.security.resources = new ArrayList();
        OGlobalConfiguration.STORAGE_COMPRESSION_METHOD.setValue((Object)"nothing");
        OGlobalConfiguration.FILE_LOCK.setValue((Object)false);
        OGlobalConfiguration.DISTRIBUTED_AUTO_REMOVE_OFFLINE_SERVERS.setValue((Object)-1);
        if (this.binaryMaxLengthKB > 0) {
            this.log.info("NETWORK_BINARY_MAX_CONTENT_LENGTH/{} Default:{} Overriding from Current:{} to New:{}", new Object[]{OGlobalConfiguration.NETWORK_BINARY_MAX_CONTENT_LENGTH.getKey(), OGlobalConfiguration.NETWORK_BINARY_MAX_CONTENT_LENGTH.getDefValue(), OGlobalConfiguration.NETWORK_BINARY_MAX_CONTENT_LENGTH.getValue(), this.binaryMaxLengthKB});
            OGlobalConfiguration.NETWORK_BINARY_MAX_CONTENT_LENGTH.setValue((Object)this.binaryMaxLengthKB);
        }
        this.configCustomizers.forEach(it -> it.apply(config));
        if (binaryListener != null) {
            this.log.info("Binary listener enabled: {}:[{}]", (Object)binaryListener.ipAddress, (Object)binaryListener.portRange);
        }
        if (httpListener != null) {
            this.log.info("HTTP listener enabled: {}:[{}]", (Object)httpListener.ipAddress, (Object)httpListener.portRange);
        }
        return config;
    }

    private OServerNetworkListenerConfiguration createBinaryListener(String binaryPortRange) {
        OServerNetworkListenerConfiguration listener = new OServerNetworkListenerConfiguration();
        listener.ipAddress = "0.0.0.0";
        listener.portRange = binaryPortRange;
        listener.protocol = "binary";
        listener.socket = "default";
        return listener;
    }

    private OServerNetworkListenerConfiguration createHttpListener(String httpPortRange) {
        OServerNetworkListenerConfiguration listener = new OServerNetworkListenerConfiguration();
        listener.ipAddress = "0.0.0.0";
        listener.portRange = httpPortRange;
        listener.protocol = "http";
        listener.socket = "default";
        listener.parameters = new OServerParameterConfiguration[]{new OServerParameterConfiguration("network.http.charset", "UTF-8"), new OServerParameterConfiguration("network.http.jsonResponseError", "true")};
        OServerCommandConfiguration getCommand = new OServerCommandConfiguration();
        getCommand.implementation = OServerCommandGetStaticContent.class.getName();
        getCommand.pattern = "GET|www GET|studio/ GET| GET|*.htm GET|*.html GET|*.xml GET|*.jpeg GET|*.jpg GET|*.png GET|*.gif GET|*.js GET|*.css GET|*.swf GET|*.ico GET|*.txt GET|*.otf GET|*.pjs GET|*.svg GET|*.json GET|*.woff GET|*.ttf GET|*.svgz";
        getCommand.parameters = new OServerEntryConfiguration[]{new OServerEntryConfiguration("http.cache:*.htm *.html", "Cache-Control: no-cache, no-store, max-age=0, must-revalidate\\r\\nPragma: no-cache"), new OServerEntryConfiguration("http.cache:default", "Cache-Control: max-age=120")};
        listener.commands = new OServerCommandConfiguration[]{getCommand};
        return listener;
    }

    protected void doStop() throws Exception {
        try {
            this.orientServer.shutdown();
            this.orientServer = null;
        }
        finally {
            Orient.instance().shutdown();
        }
        this.log.info("Shutdown");
    }

    @Guarded(by={"STARTED"})
    public List<String> databases() {
        return ImmutableList.copyOf(this.getExistingDatabaseUrls().keySet());
    }

    @Guarded(by={"STARTED"})
    public OServer getOrientServer() {
        return this.orientServer;
    }

    @Subscribe
    public void onLoggerLevelChanged(LoggerLevelChangedEvent event) {
        String logger = event.getLogger();
        if (ORIENTDB_LOGGER.startsWith(logger) || logger.startsWith(ORIENTDB_LOGGER) || "ROOT".equals(logger)) {
            this.configureOrientMinimumLogLevel();
        }
    }

    @Subscribe
    public void onLoggersReset(LoggersResetEvent event) {
        this.configureOrientMinimumLogLevel();
    }

    private void configureOrientMinimumLogLevel() {
        int minimumLevel = this.getOrientMininumLogLevel();
        this.log.debug("Configuring OrientDB global minimum log level to {}", (Object)minimumLevel);
        OLogManager logManager = OLogManager.instance();
        logManager.setDebugEnabled(minimumLevel <= Level.FINE.intValue());
        logManager.setInfoEnabled(minimumLevel <= Level.INFO.intValue());
        logManager.setWarnEnabled(minimumLevel <= Level.WARNING.intValue());
        logManager.setErrorEnabled(minimumLevel <= Level.SEVERE.intValue());
    }

    private int getOrientMininumLogLevel() {
        int minimumLogLevel = 0;
        String[] stringArray = new String[]{ORIENTDB_LOGGER, ORIENTDB_PARENT_LOGGER, JUL_ROOT_LOGGER};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String loggerName = stringArray[n2];
            Integer logLevel = this.getSafeLogLevel(loggerName);
            if (logLevel != null) {
                minimumLogLevel = logLevel;
                break;
            }
            ++n2;
        }
        String orientLoggerPrefix = "com.orientechnologies.";
        Enumeration<String> en = LogManager.getLogManager().getLoggerNames();
        while (en.hasMoreElements() && minimumLogLevel > Level.FINE.intValue()) {
            Integer logLevel;
            String loggerName = en.nextElement();
            if (!loggerName.startsWith(orientLoggerPrefix) || (logLevel = this.getSafeLogLevel(loggerName)) == null || logLevel >= minimumLogLevel) continue;
            minimumLogLevel = logLevel;
        }
        return minimumLogLevel;
    }

    @Nullable
    private Integer getSafeLogLevel(String loggerName) {
        Logger logger = LogManager.getLogManager().getLogger(loggerName);
        if (logger == null) {
            return null;
        }
        Level level = logger.getLevel();
        return level != null ? Integer.valueOf(level.intValue()) : null;
    }

    @Named
    @Singleton
    private static class OServerProvider
    implements Provider<OServer> {
        private final DatabaseServerImpl databaseServer;

        @Inject
        public OServerProvider(DatabaseServerImpl databaseServer) {
            this.databaseServer = (DatabaseServerImpl)((Object)Preconditions.checkNotNull((Object)((Object)databaseServer)));
        }

        public OServer get() {
            return this.databaseServer.getOrientServer();
        }
    }
}

