/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.node.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.node.orient.OrientNodeAccess;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.internal.node.NodeIdEncoding;
import org.sonatype.nexus.ssl.CertificateUtil;
import org.sonatype.nexus.ssl.KeyStoreManager;

@Named(value="local")
@Singleton
public class OrientLocalNodeAccess
extends StateGuardLifecycleSupport
implements OrientNodeAccess {
    private final Provider<KeyStoreManager> keyStoreProvider;
    private Certificate certificate;
    private String fingerprint;
    private String id;
    private Map<String, String> memberAliases = Collections.emptyMap();

    @Inject
    public OrientLocalNodeAccess(@Named(value="node") Provider<KeyStoreManager> keyStoreProvider) {
        this.keyStoreProvider = (Provider)Preconditions.checkNotNull(keyStoreProvider);
    }

    protected void doStart() throws Exception {
        KeyStoreManager keyStoreManager = (KeyStoreManager)this.keyStoreProvider.get();
        if (!keyStoreManager.isKeyPairInitialized()) {
            this.log.info("Generating certificate");
            UUID cn = UUID.randomUUID();
            keyStoreManager.generateAndStoreKeyPair(cn.toString(), "Nexus", "Sonatype", "Silver Spring", "MD", "US");
        }
        this.certificate = keyStoreManager.getCertificate();
        this.log.trace("Certificate:\n{}", (Object)this.certificate);
        this.fingerprint = CertificateUtil.calculateFingerprint((Certificate)this.certificate);
        this.log.debug("Fingerprint: {}", (Object)this.fingerprint);
        this.id = NodeIdEncoding.nodeIdForCertificate(this.certificate);
        this.log.info("ID: {}", (Object)this.id);
        this.memberAliases = ImmutableMap.of((Object)this.id, (Object)this.id);
    }

    protected void doStop() throws Exception {
        this.certificate = null;
        this.fingerprint = null;
        this.id = null;
    }

    @Guarded(by={"STARTED"})
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Guarded(by={"STARTED"})
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Guarded(by={"STARTED"})
    public String getId() {
        return this.id;
    }

    @Guarded(by={"STARTED"})
    public String getClusterId() {
        return this.getId();
    }

    public boolean isClustered() {
        return false;
    }

    public Set<String> getMemberIds() {
        return this.memberAliases.keySet();
    }

    public boolean isOldestNode() {
        return true;
    }

    public Map<String, String> getMemberAliases() {
        return this.memberAliases;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "id='" + this.id + '\'' + '}';
    }
}

