/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.node.datastore;

import com.google.common.base.Preconditions;
import java.security.cert.Certificate;
import java.sql.Connection;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.internal.node.NodeIdEncoding;
import org.sonatype.nexus.node.datastore.NodeIdStore;
import org.sonatype.nexus.ssl.KeyStoreManager;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;

@Named
public class NodeIdUpgradeStep_1_14
extends ComponentSupport
implements DatabaseMigrationStep {
    private final NodeIdStore nodeIdStore;
    private final Provider<KeyStoreManager> keyStoreProvider;

    @Inject
    public NodeIdUpgradeStep_1_14(@Named(value="node") Provider<KeyStoreManager> keyStoreProvider, NodeIdStore nodeIdStore) {
        this.nodeIdStore = (NodeIdStore)Preconditions.checkNotNull((Object)nodeIdStore);
        this.keyStoreProvider = (Provider)Preconditions.checkNotNull(keyStoreProvider);
    }

    public Optional<String> version() {
        return Optional.of("1.14");
    }

    public void migrate(Connection connection) throws Exception {
        if (this.nodeIdStore.get().isPresent()) {
            this.log.debug("Found existing nodeId.");
            return;
        }
        this.migrateNodeId();
    }

    private void migrateNodeId() throws Exception {
        KeyStoreManager keyStoreManager = (KeyStoreManager)this.keyStoreProvider.get();
        if (!keyStoreManager.isKeyPairInitialized()) {
            this.nodeIdStore.getOrCreate();
            return;
        }
        this.log.info("Migrating node-id to database");
        Certificate certificate = keyStoreManager.getCertificate();
        this.log.trace("Certificate:\n{}", (Object)certificate);
        String id = NodeIdEncoding.nodeIdForCertificate(certificate);
        this.nodeIdStore.set(id);
    }
}

