/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.node.datastore;

import com.google.common.hash.Hashing;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.datastore.api.DuplicateKeyException;
import org.sonatype.nexus.internal.node.NodeIdEncoding;
import org.sonatype.nexus.internal.node.datastore.NodeIdDAO;
import org.sonatype.nexus.node.datastore.NodeIdStore;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class NodeIdStoreImpl
extends ConfigStoreSupport<NodeIdDAO>
implements NodeIdStore {
    @Inject
    public NodeIdStoreImpl(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier);
    }

    @Override
    @Transactional
    public void clear() {
        ((NodeIdDAO)this.dao()).clear();
    }

    @Override
    @Transactional
    public Optional<String> get() {
        return ((NodeIdDAO)this.dao()).get();
    }

    @Override
    @Transactional
    public void set(String nodeId) {
        ((NodeIdDAO)this.dao()).set(nodeId);
    }

    @Override
    @Transactional(retryOn={DuplicateKeyException.class})
    public String getOrCreate() {
        return this.get().orElseGet(() -> {
            String newNodeId = this.generateNodeId();
            ((NodeIdDAO)this.dao()).create(newNodeId);
            return newNodeId;
        });
    }

    private String generateNodeId() {
        this.log.debug("Generating nodeId");
        UUID cn = UUID.randomUUID();
        String newNodeId = NodeIdEncoding.nodeIdForSha1(Hashing.sha1().hashBytes(cn.toString().getBytes()).toString());
        return newNodeId;
    }
}

