/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.node.datastore;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.internal.node.datastore.NodeIdApiResourceDoc;
import org.sonatype.nexus.node.datastore.NodeIdStore;
import org.sonatype.nexus.rest.Resource;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/v1/system/node")
@Named
@Singleton
public class NodeIdApiResource
extends ComponentSupport
implements Resource,
NodeIdApiResourceDoc {
    public static final String PATH = "/v1/system/node";
    private final NodeIdStore nodeIdStore;
    private final NodeAccess nodeAccess;

    @Inject
    public NodeIdApiResource(NodeIdStore nodeIdStore, NodeAccess nodeAccess) {
        this.nodeIdStore = nodeIdStore;
        this.nodeAccess = nodeAccess;
    }

    @Override
    @GET
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public NodeInformation getNodeId() {
        return new NodeInformation(this.nodeAccess.getId());
    }

    @Override
    @DELETE
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public void clear() {
        this.nodeIdStore.clear();
    }

    public static class NodeInformation {
        public final String nodeId;

        public NodeInformation(String nodeId) {
            this.nodeId = nodeId;
        }
    }
}

