/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.node.datastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.node.datastore.NodeIdStore;

@Named(value="local")
@Singleton
public class LocalNodeAccess
extends StateGuardLifecycleSupport
implements NodeAccess {
    private final NodeIdStore nodeIdStore;
    private String id;
    private Map<String, String> memberAliases = Collections.emptyMap();

    @Inject
    public LocalNodeAccess(NodeIdStore nodeIdStore) {
        this.nodeIdStore = (NodeIdStore)Preconditions.checkNotNull((Object)nodeIdStore);
    }

    protected void doStart() throws Exception {
        this.id = this.nodeIdStore.getOrCreate();
        this.log.info("ID: {}", (Object)this.id);
        this.memberAliases = ImmutableMap.of((Object)this.id, (Object)this.id);
    }

    protected void doStop() throws Exception {
        this.id = null;
    }

    @Guarded(by={"STARTED"})
    public String getId() {
        return this.id;
    }

    @Guarded(by={"STARTED"})
    public String getClusterId() {
        return this.getId();
    }

    public boolean isClustered() {
        return false;
    }

    public boolean isOldestNode() {
        return true;
    }

    public Set<String> getMemberIds() {
        return this.memberAliases.keySet();
    }

    public Map<String, String> getMemberAliases() {
        return this.memberAliases;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "id='" + this.id + '\'' + '}';
    }
}

