/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.node;

import com.google.common.base.Preconditions;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.ssl.CertificateUtil;

public class NodeIdEncoding {
    private NodeIdEncoding() {
    }

    public static String nodeIdForSha1(String input) {
        Preconditions.checkNotNull((Object)input);
        return Strings2.encodeSeparator((String)input, (char)'-', (int)8);
    }

    public static String sha1ForNodeId(String input) {
        Preconditions.checkNotNull((Object)input);
        return input.replaceAll("-", "");
    }

    public static String nodeIdForCertificate(Certificate cert) throws CertificateEncodingException {
        Preconditions.checkNotNull((Object)cert);
        String sha1 = CertificateUtil.calculateSha1((Certificate)cert);
        return NodeIdEncoding.nodeIdForSha1(sha1);
    }

    public static String nodeIdForFingerprint(String fingerprint) {
        Preconditions.checkNotNull((Object)fingerprint);
        String sha1 = fingerprint.replace(":", "");
        return NodeIdEncoding.nodeIdForSha1(sha1);
    }
}

