/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.node;

import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.ssl.KeyStoreManagerConfigurationSupport;

@Named(value="node")
@Singleton
public class KeyStoreManagerConfigurationImpl
extends KeyStoreManagerConfigurationSupport {
    private static final String CPREFIX = "${node.keyStoreManager";
    private static final char[] PKSP = "uuPWrk3UEQRaolpd".toCharArray();
    private static final char[] TKSP = "1bmcqcHV3sp6fVKD".toCharArray();
    private static final char[] PKP = "CyQM8zCFeorarTA8".toCharArray();

    @Inject
    public KeyStoreManagerConfigurationImpl(@Named(value="${node.keyStoreManager.keyStoreType:-JKS}") String keyStoreType, @Named(value="${node.keyStoreManager.keyAlgorithm:-RSA}") String keyAlgorithm, @Named(value="${node.keyStoreManager.keyAlgorithmSize:-2048}") int keyAlgorithmSize, @Named(value="${node.keyStoreManager.certificateValidity:-36500d}") Time certificateValidity, @Named(value="${node.keyStoreManager.signatureAlgorithm:-SHA1WITHRSA}") String signatureAlgorithm, @Named(value="${node.keyStoreManager.keyManagerAlgorithm:-DEFAULT}") String keyManagerAlgorithm, @Named(value="${node.keyStoreManager.trustManagerAlgorithm:-DEFAULT}") String trustManagerAlgorithm) {
        this.setPrivateKeyStorePassword(PKSP);
        this.setTrustedKeyStorePassword(TKSP);
        this.setPrivateKeyPassword(PKP);
        this.setKeyStoreType(keyStoreType);
        this.setKeyAlgorithm(keyAlgorithm);
        this.setKeyAlgorithmSize(keyAlgorithmSize);
        this.setCertificateValidity(certificateValidity);
        this.setSignatureAlgorithm(signatureAlgorithm);
        this.setKeyManagerAlgorithm(keyManagerAlgorithm);
        this.setTrustManagerAlgorithm(trustManagerAlgorithm);
    }

    @VisibleForTesting
    public KeyStoreManagerConfigurationImpl() {
        this.setPrivateKeyStorePassword(PKSP);
        this.setTrustedKeyStorePassword(TKSP);
        this.setPrivateKeyPassword(PKP);
    }
}

