/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Provider;
import org.joda.time.base.AbstractInstant;
import org.joda.time.base.BaseDateTime;
import org.sonatype.nexus.common.app.FreezeRequest;
import org.sonatype.nexus.common.app.FreezeService;

public class ReadOnlyMetricSet
implements MetricSet {
    private final Map<String, Metric> metrics;

    public ReadOnlyMetricSet(Provider<FreezeService> freezeServiceProvider) {
        Preconditions.checkNotNull(freezeServiceProvider);
        this.metrics = ImmutableMap.of((Object)"enabled", (Object)this.enabled(freezeServiceProvider), (Object)"pending", (Object)this.pending(freezeServiceProvider), (Object)"freezeTime", (Object)this.freezeTime(freezeServiceProvider));
    }

    public Map<String, Metric> getMetrics() {
        return this.metrics;
    }

    private Metric enabled(Provider<FreezeService> freezeServiceProvider) {
        return () -> Optional.ofNullable((FreezeService)freezeServiceProvider.get()).map(FreezeService::isFrozen).orElse(false);
    }

    private Metric pending(Provider<FreezeService> freezeServiceProvider) {
        return () -> Optional.ofNullable((FreezeService)freezeServiceProvider.get()).map(freezeService -> freezeService.currentFreezeRequests().size()).orElse(0);
    }

    private Metric freezeTime(Provider<FreezeService> freezeServiceProvider) {
        return () -> Optional.ofNullable((FreezeService)freezeServiceProvider.get()).map(freezeService -> {
            Long val = freezeService.currentFreezeRequests().stream().map(FreezeRequest::frozenAt).min(AbstractInstant::compareTo).map(BaseDateTime::getMillis).orElse(0L);
            return val;
        }).orElse(0L);
    }
}

