/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.metrics;

import com.codahale.metrics.Clock;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Module;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.internal.metrics.MetricsModule;
import org.sonatype.nexus.internal.metrics.MetricsServletModule;
import org.sonatype.nexus.security.FilterChainModule;
import org.sonatype.nexus.security.JwtSecurityFilter;
import org.sonatype.nexus.security.authz.PermissionsFilter;

@Named
@FeatureFlag(name="nexus.jwt.enabled")
public class JwtMetricsModule
extends MetricsModule {
    private static final Logger log = LoggerFactory.getLogger(JwtMetricsModule.class);

    @Override
    protected void configure() {
        Clock clock = Clock.defaultClock();
        this.bind(Clock.class).toInstance((Object)clock);
        JsonFactory jsonFactory = new JsonFactory((ObjectCodec)new ObjectMapper());
        this.bind(JsonFactory.class).toInstance((Object)jsonFactory);
        this.install((Module)new MetricsServletModule("/service/metrics"){

            @Override
            protected void bindSecurityFilter() {
                this.filter("/service/metrics/*", new String[0]).through(JwtSecurityFilter.class);
            }
        });
        this.install((Module)new FilterChainModule(){

            protected void configure() {
                this.addFilterChain("/service/metrics/**", new String[]{"nx-authc", "nx-jwt", "nx-anonymous", "nx-anticsrf-authc", PermissionsFilter.config((String[])new String[]{"nexus:metrics:read"})});
            }
        });
        log.info("Metrics support configured");
    }
}

