/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.log;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.support.table.ShellTable;
import org.sonatype.nexus.common.log.LogManager;

@Named
@Command(name="loggers", scope="nexus", description="Display loggers")
public class LoggersAction
implements Action {
    private final LogManager logManager;
    @Option(name="-r", aliases={"--reset"}, description="Reset loggers")
    private Boolean reset;

    @Inject
    public LoggersAction(LogManager logManager) {
        this.logManager = (LogManager)Preconditions.checkNotNull((Object)logManager);
    }

    public Object execute() throws Exception {
        if (Boolean.TRUE.equals(this.reset)) {
            this.logManager.resetLoggers();
        } else {
            ShellTable table = new ShellTable();
            table.column("Name");
            table.column("Level").alignRight();
            this.logManager.getLoggers().keySet().stream().sorted().forEach(key -> table.addRow().addContent(new Object[]{key, this.logManager.getLoggers().get(key)}));
            table.print(System.out);
        }
        return null;
    }
}

