/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.log;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.sonatype.nexus.common.log.LogManager;
import org.sonatype.nexus.common.log.LoggerLevel;
import org.sonatype.nexus.internal.log.LoggerNameCompleter;

@Named
@Command(name="logger", scope="nexus", description="Set or display logger level")
public class LoggerAction
implements Action {
    private final LogManager logManager;
    @Option(name="-d", aliases={"--delete"}, description="Delete logger")
    private Boolean delete;
    @Option(name="-e", aliases={"--effective"}, description="Return effective logger level")
    private Boolean effective;
    @Argument(name="name", index=0, required=true, description="Logger name")
    @Completion(value=LoggerNameCompleter.class)
    private String name;
    @Argument(name="level", index=1, description="Logger level")
    private LoggerLevel level;

    @Inject
    public LoggerAction(LogManager logManager) {
        this.logManager = (LogManager)Preconditions.checkNotNull((Object)logManager);
    }

    public Object execute() throws Exception {
        if (Boolean.TRUE.equals(this.delete)) {
            this.logManager.unsetLoggerLevel(this.name);
        } else if (this.level != null) {
            this.logManager.setLoggerLevel(this.name, this.level);
        } else {
            this.level = Boolean.TRUE.equals(this.effective) ? this.logManager.getLoggerEffectiveLevel(this.name) : this.logManager.getLoggerLevel(this.name);
            if (this.level != null) {
                System.out.println(String.valueOf(this.name) + " = " + this.level.toString());
            } else {
                System.out.println(String.valueOf(this.name) + " is not set");
            }
        }
        return null;
    }
}

