/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.log;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.FileReplacer;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.io.SafeXml;
import org.sonatype.nexus.common.log.LoggerLevel;
import org.sonatype.nexus.internal.log.LoggerOverrides;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Named
@Singleton
public class LogbackLoggerOverrides
extends ComponentSupport
implements LoggerOverrides {
    private final File file;
    private final Map<String, LoggerLevel> loggerLevels = new HashMap<String, LoggerLevel>();

    @Inject
    public LogbackLoggerOverrides(ApplicationDirectories applicationDirectories) {
        Preconditions.checkNotNull((Object)applicationDirectories);
        this.file = new File(applicationDirectories.getWorkDirectory("etc/logback"), "logback-overrides.xml");
        this.log.info("File: {}", (Object)this.file);
    }

    @VisibleForTesting
    LogbackLoggerOverrides(File file) {
        this.file = (File)Preconditions.checkNotNull((Object)file);
    }

    @Override
    public synchronized void load() {
        this.log.debug("Load");
        this.loggerLevels.clear();
        if (this.file.exists()) {
            try {
                this.loggerLevels.putAll(this.read(this.file));
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public synchronized void save() {
        this.log.debug("Save");
        try {
            this.write(this.file, this.loggerLevels);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void reset() {
        this.log.debug("Reset");
        this.loggerLevels.clear();
        try {
            this.write(this.file, this.loggerLevels);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void set(String name, LoggerLevel level) {
        this.log.debug("Set: {}={}", (Object)name, (Object)level);
        this.loggerLevels.put(name, level);
    }

    @Override
    @Nullable
    public synchronized LoggerLevel get(String name) {
        return this.loggerLevels.get(name);
    }

    @Override
    @Nullable
    public synchronized LoggerLevel remove(String name) {
        this.log.debug("Remove: {}", (Object)name);
        return this.loggerLevels.remove(name);
    }

    @Override
    public synchronized boolean contains(String name) {
        return this.loggerLevels.containsKey(name);
    }

    @Override
    public synchronized Iterator<Map.Entry<String, LoggerLevel>> iterator() {
        return ImmutableMap.copyOf(this.loggerLevels).entrySet().iterator();
    }

    private Map<String, LoggerLevel> read(File inputFile) throws Exception {
        final HashMap result = Maps.newHashMap();
        SAXParserFactory parserFactory = SafeXml.newSaxParserFactory();
        parserFactory.setValidating(false);
        parserFactory.setNamespaceAware(true);
        SAXParser parser = parserFactory.newSAXParser();
        parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        parser.parse(inputFile, new DefaultHandler(){

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if ("logger".equals(localName)) {
                    String name = attributes.getValue("name");
                    String level = attributes.getValue("level");
                    result.put(name, LoggerLevel.valueOf((String)level));
                }
            }
        });
        return result;
    }

    private void write(File outputFile, Map<String, LoggerLevel> overrides) throws Exception {
        FileReplacer fileReplacer = new FileReplacer(outputFile);
        fileReplacer.setDeleteBackupFile(true);
        fileReplacer.replace(output -> {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)output, StandardCharsets.UTF_8));){
                out.write("<?xml version='1.0' encoding='UTF-8'?>");
                out.newLine();
                out.newLine();
                out.write("<!--");
                out.newLine();
                out.write("DO NOT EDIT - Automatically generated; User-customized logging levels");
                out.newLine();
                out.write("-->");
                out.newLine();
                out.newLine();
                out.write("<included>");
                out.newLine();
                for (Map.Entry entry : overrides.entrySet()) {
                    if ("ROOT".equals(entry.getKey())) {
                        out.write(String.format("  <property name='root.level' value='%s'/>%n", entry.getValue()));
                        continue;
                    }
                    out.write(String.format("  <logger name='%s' level='%s'/>%n", entry.getKey(), entry.getValue()));
                }
                out.write("</included>");
                out.newLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
    }
}

