/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.inject.Key;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.BeanLocator;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.log.LogConfigurationCustomizer;
import org.sonatype.nexus.common.log.LogManager;
import org.sonatype.nexus.common.log.LoggerLevel;
import org.sonatype.nexus.common.log.LoggerLevelChangedEvent;
import org.sonatype.nexus.common.log.LoggersResetEvent;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.internal.log.LogbackLevels;
import org.sonatype.nexus.internal.log.LoggerOverrides;
import org.sonatype.nexus.logging.task.TaskLogHome;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.KERNEL)
@Singleton
public class LogbackLogManager
extends StateGuardLifecycleSupport
implements LogManager {
    private static final String TASKS_PREFIX = "tasks/";
    private final EventManager eventManager;
    private final BeanLocator beanLocator;
    private final Map<String, LoggerLevel> customizations;
    private final LoggerOverrides overrides;

    @Inject
    public LogbackLogManager(EventManager eventManager, BeanLocator beanLocator, LoggerOverrides overrides) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.beanLocator = (BeanLocator)Preconditions.checkNotNull((Object)beanLocator);
        this.overrides = (LoggerOverrides)Preconditions.checkNotNull((Object)overrides);
        this.customizations = new HashMap<String, LoggerLevel>();
    }

    protected void doStart() throws Exception {
        this.configure();
        this.beanLocator.watch(Key.get(LogConfigurationCustomizer.class, Named.class), (Mediator)new CustomizerMediator(), (Object)this);
    }

    private void configure() {
        this.log.info("Configuring");
        this.customizations.clear();
        this.overrides.load();
        for (Map.Entry entry : this.overrides) {
            this.setLogbackLoggerLevel((String)entry.getKey(), LogbackLevels.convert((LoggerLevel)entry.getValue()));
        }
    }

    protected void doStop() throws Exception {
        LogbackLogManager.loggerContext().stop();
    }

    @Guarded(by={"STARTED"})
    public Optional<String> getLogFor(String loggerName) {
        return LogbackLogManager.getLogFor(loggerName, LogbackLogManager.appenders());
    }

    @Guarded(by={"STARTED"})
    public Optional<File> getLogFileForLogger(String loggerName) {
        return this.getLogFor(loggerName).map(this::getLogFile);
    }

    @VisibleForTesting
    static Optional<String> getLogFor(String loggerName, Collection<Appender<ILoggingEvent>> appenders) {
        return appenders.stream().filter(appender -> loggerName.equals(appender.getName())).filter(FileAppender.class::isInstance).map(fileAppender -> ((FileAppender)fileAppender).getFile()).map(FilenameUtils::getName).filter(Objects::nonNull).findFirst();
    }

    @Guarded(by={"STARTED"})
    public Set<File> getLogFiles() {
        return LogbackLogManager.appenders().stream().filter(FileAppender.class::isInstance).map(fileAppender -> ((FileAppender)fileAppender).getFile()).map(File::new).filter(file -> file.length() > 0L).collect(Collectors.toSet());
    }

    @Nullable
    @Guarded(by={"STARTED"})
    public File getLogFile(String fileName) {
        String filePrefix = fileName.startsWith(TASKS_PREFIX) ? TASKS_PREFIX : "";
        return Objects.requireNonNull(this.getAllLogFiles(fileName).orElse(null)).stream().filter(file -> fileName.equals(String.valueOf(filePrefix) + file.getName())).findFirst().orElseGet(() -> {
            this.log.error("Unable to find log file");
            return null;
        });
    }

    @Nullable
    @Guarded(by={"STARTED"})
    public InputStream getLogFileStream(String fileName, long from, long count) throws IOException {
        this.log.debug("Retrieving log file");
        if ((fileName.contains(File.pathSeparator) || fileName.contains("/")) && !fileName.startsWith(TASKS_PREFIX)) {
            this.log.warn("Cannot retrieve log files with path separators in their name, unless it is a task log");
            return null;
        }
        File file = this.getLogFile(fileName);
        if (file == null || !file.exists()) {
            this.log.warn("Log file does not exist");
            return null;
        }
        long fromByte = from;
        long bytesCount = count;
        if (count < 0L) {
            bytesCount = Math.abs(count);
            fromByte = Math.max(0L, file.length() - bytesCount);
        }
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
        if (fromByte == 0L && bytesCount >= file.length()) {
            return input;
        }
        ((InputStream)input).skip(fromByte);
        return ByteStreams.limit((InputStream)input, (long)bytesCount);
    }

    @Guarded(by={"STARTED"})
    public Map<String, LoggerLevel> getLoggers() {
        Level level;
        String name;
        HashMap<String, LoggerLevel> loggers = new HashMap<String, LoggerLevel>();
        LoggerContext ctx = LogbackLogManager.loggerContext();
        for (ch.qos.logback.classic.Logger logger : ctx.getLoggerList()) {
            name = logger.getName();
            level = logger.getLevel();
            if (level == null) continue;
            loggers.put(name, LogbackLevels.convert(level));
        }
        for (Map.Entry entry : this.customizations.entrySet()) {
            name = (String)entry.getKey();
            level = (LoggerLevel)entry.getValue();
            if (loggers.containsKey(name)) continue;
            if (LoggerLevel.DEFAULT == level) {
                level = this.getLoggerEffectiveLevel((String)entry.getKey());
            }
            loggers.put(name, (LoggerLevel)level);
        }
        return loggers;
    }

    @Guarded(by={"STARTED"})
    public Map<String, LoggerLevel> getOverriddenLoggers() {
        HashMap<String, LoggerLevel> loggers = new HashMap<String, LoggerLevel>();
        this.overrides.forEach(override -> {
            LoggerLevel loggerLevel = loggers.put((String)override.getKey(), (LoggerLevel)override.getValue());
        });
        return loggers;
    }

    @Guarded(by={"STARTED"})
    public void resetLoggers() {
        this.log.debug("Resetting loggers");
        for (Map.Entry entry : this.overrides) {
            if ("ROOT".equals(entry.getKey())) continue;
            this.setLogbackLoggerLevel((String)entry.getKey(), null);
        }
        this.overrides.reset();
        this.setLoggerLevel("ROOT", LoggerLevel.DEFAULT);
        this.applyCustomizations();
        this.eventManager.post((Object)new LoggersResetEvent());
        this.log.debug("Loggers reset to default levels");
    }

    @Guarded(by={"STARTED"})
    public void setLoggerLevel(String name, @Nullable LoggerLevel level) {
        if (level == null) {
            this.unsetLoggerLevel(name);
            return;
        }
        this.log.debug("Set logger level: {}={}", (Object)name, (Object)level);
        LoggerLevel calculated = null;
        if ("ROOT".equals(name)) {
            calculated = level == LoggerLevel.DEFAULT ? LoggerLevel.INFO : level;
            this.overrides.set(name, calculated);
        } else if (level == LoggerLevel.DEFAULT) {
            boolean customizedByUser = this.overrides.contains(name) && !this.customizations.containsKey(name);
            this.unsetLoggerLevel(name);
            if (customizedByUser) {
                calculated = this.getLoggerEffectiveLevel(name);
                this.overrides.set(name, calculated);
            } else {
                LoggerLevel customizedLevel = this.customizations.get(name);
                if (customizedLevel != null && customizedLevel != LoggerLevel.DEFAULT) {
                    calculated = customizedLevel;
                }
            }
        } else {
            calculated = level;
            this.overrides.set(name, calculated);
        }
        this.overrides.save();
        if (calculated != null) {
            this.setLogbackLoggerLevel(name, LogbackLevels.convert(calculated));
        }
        this.eventManager.post((Object)new LoggerLevelChangedEvent(name, level));
    }

    @Guarded(by={"STARTED"})
    public void unsetLoggerLevel(String name) {
        this.log.debug("Unset logger level: {}", (Object)name);
        if (this.overrides.remove(name) != null) {
            this.overrides.save();
        }
        if ("ROOT".equals(name)) {
            this.setLogbackLoggerLevel(name, Level.INFO);
        } else {
            this.setLogbackLoggerLevel(name, null);
        }
        this.eventManager.post((Object)new LoggerLevelChangedEvent(name, null));
    }

    @Nullable
    @Guarded(by={"STARTED"})
    public LoggerLevel getLoggerLevel(String name) {
        Level level = LogbackLogManager.loggerContext().getLogger(name).getLevel();
        if (level != null) {
            return LogbackLevels.convert(level);
        }
        return null;
    }

    @Guarded(by={"STARTED"})
    public LoggerLevel getLoggerEffectiveLevel(String name) {
        Level level = LogbackLogManager.loggerContext().getLogger(name).getEffectiveLevel();
        return LogbackLevels.convert(level);
    }

    private void setLogbackLoggerLevel(String name, @Nullable Level level) {
        this.log.trace("Set logback logger level: {}={}", (Object)name, (Object)level);
        LogbackLogManager.loggerContext().getLogger(name).setLevel(level);
    }

    @VisibleForTesting
    void registerCustomization(LogConfigurationCustomizer customizer) {
        this.log.debug("Registering customizations: {}", (Object)customizer);
        customizer.customize((name, level) -> {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)level);
            this.customizations.put(name, level);
            if (!this.overrides.contains(name) && level != LoggerLevel.DEFAULT) {
                this.setLogbackLoggerLevel(name, LogbackLevels.convert(level));
            }
        });
    }

    private void applyCustomizations() {
        this.log.debug("Applying customizations");
        for (Map.Entry<String, LoggerLevel> entry : this.customizations.entrySet()) {
            if (entry.getValue() == LoggerLevel.DEFAULT) continue;
            this.setLogbackLoggerLevel(entry.getKey(), LogbackLevels.convert(entry.getValue()));
        }
    }

    @VisibleForTesting
    static LoggerContext loggerContext() {
        ILoggerFactory factory = LoggerFactory.getILoggerFactory();
        if (factory instanceof LoggerContext) {
            return (LoggerContext)factory;
        }
        return (LoggerContext)StaticLoggerBinder.getSingleton().getLoggerFactory();
    }

    private static Collection<Appender<ILoggingEvent>> appenders() {
        ArrayList<Appender<ILoggingEvent>> result = new ArrayList<Appender<ILoggingEvent>>();
        for (Logger l : LogbackLogManager.loggerContext().getLoggerList()) {
            ch.qos.logback.classic.Logger log = (ch.qos.logback.classic.Logger)l;
            Iterator iter = log.iteratorForAppenders();
            while (iter.hasNext()) {
                result.add((Appender<ILoggingEvent>)((Appender)iter.next()));
            }
        }
        return result;
    }

    private Optional<Set<File>> getAllLogFiles(String fileName) {
        if (fileName.startsWith(TASKS_PREFIX) && fileName.endsWith(".log")) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (Stream<Path> tasks = Files.list(Paths.get(Objects.requireNonNull(TaskLogHome.getTaskLogHome()), new String[0]));){
                    return Optional.of(tasks.map(Path::toFile).collect(Collectors.toSet()));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.log.error("Unable to list files in the tasks directory", (Throwable)e);
                return Optional.empty();
            }
        }
        return Optional.of(this.getLogFiles());
    }

    private static class CustomizerMediator
    implements Mediator<Named, LogConfigurationCustomizer, LogbackLogManager> {
        private CustomizerMediator() {
        }

        public void add(BeanEntry<Named, LogConfigurationCustomizer> entry, LogbackLogManager watcher) {
            watcher.registerCustomization((LogConfigurationCustomizer)entry.getValue());
        }

        public void remove(BeanEntry<Named, LogConfigurationCustomizer> entry, LogbackLogManager watcher) {
        }
    }
}

