/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.jwt.datastore;

import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.internal.jwt.datastore.JwtSecretDAO;
import org.sonatype.nexus.security.jwt.SecretStore;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
@FeatureFlag(name="nexus.jwt.enabled")
public class JwtSecretStore
extends ConfigStoreSupport<JwtSecretDAO>
implements SecretStore {
    @Inject
    public JwtSecretStore(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier);
    }

    @Transactional
    public Optional<String> getSecret() {
        return ((JwtSecretDAO)this.dao()).get();
    }

    @Transactional
    public void setSecret(String secret) {
        ((JwtSecretDAO)this.dao()).set(secret);
    }

    @Transactional
    public void generateNewSecret() {
        ((JwtSecretDAO)this.dao()).setIfEmpty(UUID.randomUUID().toString());
    }
}

