/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.event;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.Time;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.internal.event.AffinityBarrier;
import org.sonatype.nexus.internal.event.EventManagerImpl;
import org.sonatype.nexus.thread.NexusExecutorService;
import org.sonatype.nexus.thread.NexusThreadFactory;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
@Singleton
class EventExecutor
extends LifecycleSupport
implements Executor {
    private static final RejectedExecutionHandler CALLER_RUNS_FAILSAFE = (command, executor) -> command.run();
    private final boolean affinityEnabled;
    private final int affinityCacheSize;
    private final Time affinityTimeout;
    private final boolean singleCoordinator;
    private final boolean fairThreading;
    private NexusExecutorService eventProcessor;
    private NexusExecutorService affinityProcessor;
    private LoadingCache<String, AffinityBarrier> affinityBarriers;
    private volatile boolean asyncProcessing;

    @Inject
    public EventExecutor(@Named(value="${nexus.event.affinityEnabled:-true}") boolean affinityEnabled, @Named(value="${nexus.event.affinityCacheSize:-1000}") int affinityCacheSize, @Named(value="${nexus.event.affinityTimeout:-1s}") Time affinityTimeout, @Named(value="${nexus.event.singleCoordinator:-false}") boolean singleCoordinator, @Named(value="${nexus.event.fairThreading:-false}") boolean fairThreading) {
        this.affinityEnabled = affinityEnabled;
        this.affinityCacheSize = affinityCacheSize;
        this.affinityTimeout = (Time)Preconditions.checkNotNull((Object)affinityTimeout);
        this.singleCoordinator = singleCoordinator;
        this.fairThreading = fairThreading;
    }

    protected void doStart() throws Exception {
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(0, EventManagerImpl.HOST_THREAD_POOL_SIZE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(this.fairThreading), (ThreadFactory)new NexusThreadFactory("event", "event-manager"), CALLER_RUNS_FAILSAFE);
        this.eventProcessor = NexusExecutorService.forCurrentSubject((ExecutorService)threadPool);
        if (this.affinityEnabled) {
            Supplier<Executor> coordinator;
            if (this.singleCoordinator) {
                ThreadPoolExecutor affinityThread = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NexusThreadFactory("affinity", "affinity-manager"), CALLER_RUNS_FAILSAFE);
                this.affinityProcessor = NexusExecutorService.forCurrentSubject((ExecutorService)affinityThread);
                coordinator = () -> this.affinityProcessor;
            } else {
                coordinator = () -> MoreExecutors.newSequentialExecutor((Executor)this.eventProcessor);
            }
            this.affinityBarriers = CacheBuilder.newBuilder().maximumSize((long)this.affinityCacheSize).build(CacheLoader.from(() -> new AffinityBarrier((Executor)coordinator.get(), (Executor)this.eventProcessor, this.affinityTimeout)));
        }
        this.asyncProcessing = true;
    }

    protected void doStop() throws Exception {
        if (this.asyncProcessing) {
            this.shutdown(this.affinityProcessor);
            this.shutdown(this.eventProcessor);
            this.asyncProcessing = false;
        }
    }

    @VisibleForTesting
    boolean isCalmPeriod() {
        if (this.asyncProcessing) {
            return this.isCalmPeriod(this.affinityProcessor) && this.isCalmPeriod(this.eventProcessor);
        }
        return true;
    }

    public boolean isAffinityEnabled() {
        return this.affinityEnabled;
    }

    public void executeWithAffinity(String affinity, Runnable postEventToAsyncBus) {
        Preconditions.checkState((boolean)this.affinityEnabled);
        if (this.asyncProcessing) {
            Runnable command = EventExecutor.inheritIsReplicating(postEventToAsyncBus);
            AffinityBarrier barrier = (AffinityBarrier)this.affinityBarriers.getUnchecked((Object)affinity);
            barrier.coordinate(command);
        } else {
            postEventToAsyncBus.run();
        }
    }

    @Override
    public void execute(Runnable deliverEventToSubscriber) {
        if (this.asyncProcessing) {
            AffinityBarrier barrier;
            Runnable command = EventExecutor.inheritIsReplicating(deliverEventToSubscriber);
            AffinityBarrier affinityBarrier = barrier = this.affinityEnabled ? AffinityBarrier.current() : null;
            if (barrier != null) {
                barrier.execute(command);
            } else {
                this.eventProcessor.execute(command);
            }
        } else {
            deliverEventToSubscriber.run();
        }
    }

    private boolean isCalmPeriod(@Nullable NexusExecutorService executorService) {
        if (executorService != null) {
            ThreadPoolExecutor threadPool = (ThreadPoolExecutor)executorService.getTargetExecutorService();
            return threadPool.getQueue().isEmpty() && threadPool.getActiveCount() == 0;
        }
        return true;
    }

    private void shutdown(@Nullable NexusExecutorService executorService) {
        if (executorService != null) {
            ThreadPoolExecutor threadPool = (ThreadPoolExecutor)executorService.getTargetExecutorService();
            threadPool.shutdown();
            try {
                threadPool.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.log.debug("Interrupted while waiting for termination", (Throwable)e);
            }
        }
    }

    private static Runnable inheritIsReplicating(Runnable command) {
        if (!EventHelper.isReplicating()) {
            return command;
        }
        return () -> {
            if (!EventHelper.isReplicating()) {
                EventHelper.asReplicating((Runnable)command);
            } else {
                command.run();
            }
        };
    }
}

