/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.datastore;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.datastore.api.DataStore;
import org.sonatype.nexus.datastore.api.DataStoreManager;
import org.sonatype.nexus.supportzip.GeneratedContentSourceSupport;
import org.sonatype.nexus.supportzip.SupportBundle;
import org.sonatype.nexus.supportzip.SupportBundleCustomizer;

@Named
@Singleton
public class MetadataDatabase
extends ComponentSupport
implements SupportBundleCustomizer {
    private static final Path PATH = Paths.get("work", new String[0]);
    private static final String CONFIG_FILE_NAME = "config_ds_info.properties";
    private static final String SECURITY_FILE_NAME = "security_ds_info.properties";
    private final DataStoreManager dataStoreManager;

    @Inject
    public MetadataDatabase(DataStoreManager dataStoreManager) {
        this.dataStoreManager = (DataStoreManager)Preconditions.checkNotNull((Object)dataStoreManager);
    }

    public void customize(SupportBundle supportBundle) {
        supportBundle.add((SupportBundle.ContentSource)this.getDbInfo(CONFIG_FILE_NAME));
        supportBundle.add((SupportBundle.ContentSource)this.getDbInfo(SECURITY_FILE_NAME));
    }

    private GeneratedContentSourceSupport getDbInfo(String fileName) {
        return new GeneratedContentSourceSupport(SupportBundle.ContentSource.Type.CONFIG, PATH.resolve(fileName).toString()){

            protected void generate(File file) throws Exception {
                Optional dataStore = MetadataDatabase.this.dataStoreManager.get("nexus");
                if (dataStore.isPresent()) {
                    Throwable throwable = null;
                    Object var4_5 = null;
                    try (FileOutputStream output = new FileOutputStream(file);){
                        Properties dsProperties = MetadataDatabase.this.getDbInfo((DataStore)dataStore.get());
                        dsProperties.store(output, null);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
        };
    }

    private Properties getDbInfo(DataStore<?> dataStore) {
        Properties dsProperties = new Properties();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = dataStore.getDataSource().getConnection();){
                dsProperties.setProperty("DatabaseProductName", connection.getMetaData().getDatabaseProductName());
                dsProperties.setProperty("DatabaseProductVersion", connection.getMetaData().getDatabaseProductVersion());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            this.log.error("Can't collect datastore information", (Throwable)e);
        }
        return dsProperties;
    }
}

