/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.datastore;

import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.supportzip.ExportConfigData;
import org.sonatype.nexus.supportzip.GeneratedContentSourceSupport;
import org.sonatype.nexus.supportzip.SupportBundle;
import org.sonatype.nexus.supportzip.SupportBundleCustomizer;

@Named
@Singleton
public class ConfigDatabase
extends ComponentSupport
implements SupportBundleCustomizer {
    private static final Path PATH = Paths.get("work", "db");
    private static final String FILE_SUFFIX = ".json";
    private final Map<String, ExportConfigData> exportDataByName;

    @Inject
    public ConfigDatabase(Map<String, ExportConfigData> exportDataByName) {
        this.exportDataByName = (Map)Preconditions.checkNotNull(exportDataByName);
    }

    public void customize(SupportBundle supportBundle) {
        for (Map.Entry<String, ExportConfigData> exporterEntry : this.exportDataByName.entrySet()) {
            supportBundle.add((SupportBundle.ContentSource)this.getExporter(String.valueOf(exporterEntry.getKey()) + FILE_SUFFIX, exporterEntry.getValue()));
        }
    }

    private GeneratedContentSourceSupport getExporter(String fileName, final ExportConfigData exporter) {
        return new GeneratedContentSourceSupport(SupportBundle.ContentSource.Type.CONFIG, PATH.resolve(fileName).toString()){

            protected void generate(File file) throws Exception {
                exporter.export(file);
            }
        };
    }
}

