/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.app;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.sisu.space.ClassSpace;

@Named(value="nexus-uber")
@Singleton
public class NexusUberClassloader
extends ClassLoader {
    private final List<ClassSpace> spaces;
    private final Cache<String, Class<?>> classLookups = CacheBuilder.newBuilder().weakValues().build();

    @Inject
    public NexusUberClassloader(List<ClassSpace> spaces) {
        this.spaces = (List)Preconditions.checkNotNull(spaces);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return (Class)this.classLookups.get((Object)name, () -> this.searchSpacesForClass(name));
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), ClassNotFoundException.class);
            throw new ClassNotFoundException(name, e.getCause());
        }
    }

    @Override
    public URL getResource(String name) {
        for (ClassSpace space : this.spaces) {
            URL result = space.getResource(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        ArrayList result = Lists.newArrayList();
        for (ClassSpace space : this.spaces) {
            Enumeration resources = space.getResources(name);
            while (resources.hasMoreElements()) {
                result.add((URL)resources.nextElement());
            }
        }
        return Collections.enumeration(result);
    }

    private Class<?> searchSpacesForClass(String name) throws ClassNotFoundException {
        for (ClassSpace space : this.spaces) {
            try {
                return space.loadClass(name);
            }
            catch (TypeNotPresentException typeNotPresentException) {}
        }
        throw new ClassNotFoundException(name);
    }
}

