/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.app;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.app.ManagedLifecycleManager;
import org.sonatype.nexus.jmx.reflect.ManagedAttribute;
import org.sonatype.nexus.jmx.reflect.ManagedObject;
import org.sonatype.nexus.jmx.reflect.ManagedOperation;

@Named
@Singleton
@ManagedObject
public class ManagedLifecycleBean
extends ComponentSupport {
    private final ManagedLifecycleManager lifecycleManager;

    @Inject
    public ManagedLifecycleBean(ManagedLifecycleManager lifecycleManager) {
        this.lifecycleManager = (ManagedLifecycleManager)Preconditions.checkNotNull((Object)lifecycleManager);
    }

    @ManagedAttribute
    public String getPhase() {
        return this.lifecycleManager.getCurrentPhase().name();
    }

    @ManagedAttribute
    public void setPhase(String phase) {
        try {
            this.lifecycleManager.to(ManagedLifecycle.Phase.valueOf((String)phase));
        }
        catch (Exception e) {
            this.log.warn("Problem moving to phase {}", (Object)phase, (Object)e);
            throw new RuntimeException("Problem moving to phase " + phase + ": " + e);
        }
    }

    @ManagedOperation
    public void bounce(String phase) {
        try {
            this.lifecycleManager.bounce(ManagedLifecycle.Phase.valueOf((String)phase));
        }
        catch (Exception e) {
            this.log.warn("Problem bouncing phase {}", (Object)phase, (Object)e);
            throw new RuntimeException("Problem bouncing phase " + phase + ": " + e);
        }
    }
}

