/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.app;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.inject.BeanLocator;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.GlobalComponentLookupHelper;

@Named
@Singleton
public class GlobalComponentLookupHelperImpl
extends ComponentSupport
implements GlobalComponentLookupHelper {
    private final ClassLoader classLoader;
    private final BeanLocator beanLocator;

    @Inject
    public GlobalComponentLookupHelperImpl(@Named(value="nexus-uber") ClassLoader classLoader, BeanLocator beanLocator) {
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader);
        this.beanLocator = (BeanLocator)Preconditions.checkNotNull((Object)beanLocator);
    }

    @Nullable
    public Object lookup(String className) {
        Preconditions.checkNotNull((Object)className);
        try {
            this.log.trace("Looking up component by class-name: {}", (Object)className);
            Class<?> type = this.classLoader.loadClass(className);
            return this.lookup(type);
        }
        catch (Exception e) {
            this.log.trace("Unable to lookup component by class-name: {}; ignoring", (Object)className, (Object)e);
            return null;
        }
    }

    @Nullable
    public <T> T lookup(Class<T> clazz) {
        Preconditions.checkNotNull(clazz);
        return (T)this.lookup(Key.get(clazz));
    }

    @Nullable
    public <T> T lookup(Class<T> clazz, String name) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull((Object)name);
        return (T)this.lookup(Key.get(clazz, (Annotation)Names.named((String)name)));
    }

    @Nullable
    public Object lookup(Key key) {
        Preconditions.checkNotNull((Object)key);
        try {
            this.log.trace("Looking up component by key: {}", (Object)key);
            Iterator iter = this.beanLocator.locate(key).iterator();
            if (iter.hasNext()) {
                return ((BeanEntry)iter.next()).getValue();
            }
            this.log.trace("Component not found for key: {}", (Object)key);
        }
        catch (Exception e) {
            this.log.trace("Unable to lookup component by key: {}; ignoring", (Object)key, (Object)e);
        }
        return null;
    }

    @Nullable
    public Class<?> type(String className) {
        Preconditions.checkNotNull((Object)className);
        try {
            this.log.trace("Looking up type: {}", (Object)className);
            return this.classLoader.loadClass(className);
        }
        catch (Exception e) {
            this.log.trace("Unable to lookup type: {}; ignoring", (Object)className, (Object)e);
            return null;
        }
    }
}

