/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.crowd.internal.rest;

import com.sonatype.nexus.crowd.internal.rest.CrowdApiXO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@Api(value="Security: Atlassian Crowd")
public interface CrowdApiResourceDoc {
    @ApiOperation(value="Retrieve Atlassian Crowd settings configured in Nexus Repository Manager")
    @ApiResponses(value={@ApiResponse(code=200, message="Atlassian Crowd settings returned"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions")})
    public CrowdApiXO readSettings();

    @ApiOperation(value="Update Atlassian Crowd settings configured in Nexus Repository Manager")
    @ApiResponses(value={@ApiResponse(code=200, message="Atlassian Crowd settings updated"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions")})
    public CrowdApiXO updateSettings(@NotNull @Valid CrowdApiXO var1);

    @ApiOperation(value="Verify connection using supplied Atlassian Crowd settings")
    @ApiResponses(value={@ApiResponse(code=204, message="Atlassian Crowd connection was successful"), @ApiResponse(code=400, message="Atlassian Crowd connection failed"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions")})
    public void verifyConnection(@NotNull @Valid CrowdApiXO var1);

    @ApiOperation(value="Clear Atlassian Crowd cache")
    @ApiResponses(value={@ApiResponse(code=204, message="Atlassian Crowd cache has been cleared"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions")})
    public void clearCache();
}

