/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.crowd.internal.rest;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.crowd.Crowd;
import com.sonatype.nexus.crowd.CrowdConfiguration;
import com.sonatype.nexus.crowd.internal.CrowdRealm;
import com.sonatype.nexus.crowd.internal.rest.CrowdApiResourceDoc;
import com.sonatype.nexus.crowd.internal.rest.CrowdApiXO;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.net.ssl.SSLException;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.DataBindingException;
import org.apache.http.client.ClientProtocolException;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.cache.Cache;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.rapture.PasswordPlaceholder;
import org.sonatype.nexus.rest.NotCacheable;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.validation.Validate;

@Produces(value={"application/json"})
public class CrowdApiResource
extends ComponentSupport
implements Resource,
CrowdApiResourceDoc {
    private final Crowd crowd;
    private final CrowdRealm crowdRealm;

    @Inject
    public CrowdApiResource(Crowd crowd, CrowdRealm crowdRealm) {
        this.crowd = (Crowd)Preconditions.checkNotNull((Object)crowd);
        this.crowdRealm = (CrowdRealm)((Object)Preconditions.checkNotNull((Object)((Object)crowdRealm)));
    }

    @Override
    @GET
    @RequiresPermissions(value={"nexus:crowd:read"})
    @NotCacheable
    public CrowdApiXO readSettings() {
        return Optional.ofNullable(this.crowd.configuration()).map(crowdConfiguration -> {
            CrowdApiXO xo = new CrowdApiXO();
            xo.setEnabled(this.crowd.isEnabled());
            xo.setRealmActive(this.crowd.isRealmActive());
            xo.setApplicationName(crowdConfiguration.getApplicationName());
            xo.setApplicationPassword(PasswordPlaceholder.get((String)crowdConfiguration.getApplicationPassword()));
            xo.setUrl(crowdConfiguration.getCrowdServerUrl());
            xo.setUseTrustStoreForUrl(crowdConfiguration.getUseTrustStore());
            xo.setTimeout(crowdConfiguration.getHttpTimeout());
            return xo;
        }).orElse(this.getBlankCrowdXo());
    }

    @Override
    @PUT
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:crowd:update"})
    @Validate
    public CrowdApiXO updateSettings(@NotNull @Valid CrowdApiXO crowdSettings) {
        this.crowd.configure(this.toConfiguration(crowdSettings));
        this.crowd.setEnabled(crowdSettings.getEnabled());
        this.crowd.setRealmActive(crowdSettings.getRealmActive());
        return this.readSettings();
    }

    @Override
    @POST
    @Path(value="/verify-connection")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:crowd:read"})
    @Validate
    public void verifyConnection(@NotNull @Valid CrowdApiXO crowdSettings) {
        try {
            this.crowd.client(this.toConfiguration(crowdSettings)).testConnection();
        }
        catch (Exception e) {
            this.logTestConnectionException(e);
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, this.getCauseMessage(e, crowdSettings));
        }
    }

    @Override
    @POST
    @Path(value="/clear-cache")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:crowd:update"})
    public void clearCache() {
        this.log.info("Clearing crowd cache");
        Cache authenticationCache = this.crowdRealm.getAuthenticationCache();
        Cache authorizationCache = this.crowdRealm.getAuthorizationCache();
        if (Objects.nonNull(authenticationCache)) {
            this.log.debug("Authentication cache size: {}", (Object)authenticationCache.size());
            authenticationCache.clear();
        }
        if (Objects.nonNull(authorizationCache)) {
            this.log.debug("Authorization cache size: {}", (Object)authorizationCache.size());
            authorizationCache.clear();
        }
    }

    private CrowdApiXO getBlankCrowdXo() {
        CrowdApiXO xo = new CrowdApiXO();
        xo.setEnabled(false);
        xo.setRealmActive(false);
        xo.setApplicationName("");
        xo.setApplicationPassword("");
        xo.setUrl("");
        xo.setUseTrustStoreForUrl(false);
        xo.setTimeout(null);
        return xo;
    }

    private CrowdConfiguration toConfiguration(CrowdApiXO crowdSettings) {
        return new CrowdConfiguration().withApplicationName(crowdSettings.getApplicationName()).withApplicationPassword(this.getPassword(crowdSettings)).withCrowdServerUrl(crowdSettings.getUrl()).withUseTrustStore(Boolean.TRUE.equals(crowdSettings.getUseTrustStoreForUrl())).withHttpTimeout(crowdSettings.getTimeout());
    }

    private String getPassword(CrowdApiXO crowdSettings) {
        CrowdConfiguration configuration;
        String password = PasswordPlaceholder.is((String)crowdSettings.getApplicationPassword()) ? (Objects.nonNull((Object)(configuration = this.crowd.configuration())) ? configuration.getApplicationPassword() : crowdSettings.getApplicationPassword()) : crowdSettings.getApplicationPassword();
        return password;
    }

    private void logTestConnectionException(Exception e) {
        this.log.debug("Found the following problem while testing Crowd connection:", (Throwable)e);
    }

    private String getCauseMessage(Exception e, CrowdApiXO crowdSettings) {
        Throwable cause;
        String message = e instanceof OperationFailedException ? ((cause = e.getCause()) instanceof SSLException ? String.format("Could not connect to %s due to an SSL problem (%s)", crowdSettings.getUrl(), cause.getMessage()) : (cause instanceof UnknownHostException ? String.format("Unknown host <%s>", cause.getMessage()) : (cause instanceof ClientProtocolException && Strings2.isEmpty((String)cause.getMessage()) ? this.getRootCause(cause).getMessage() : (cause == null ? e.getMessage() : cause.getMessage())))) : (e instanceof InvalidAuthenticationException ? "Invalid application name and/or password" : (e instanceof ApplicationPermissionException ? String.format("Application '%s' does not have required permission to list users", crowdSettings.getApplicationName()) : (e instanceof DataBindingException ? String.format("The URL %s does not specify a valid Crowd User Management REST service", crowdSettings.getUrl()) : this.getRootCause(e).getMessage())));
        return message;
    }

    private Throwable getRootCause(Throwable t) {
        if (Objects.isNull(t.getCause()) || t.getCause() == t) {
            return t;
        }
        return this.getRootCause(t.getCause());
    }
}

