/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.crowd.internal;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.integration.rest.entity.UserEntity;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyImpl;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.sonatype.nexus.crowd.Crowd;
import com.sonatype.nexus.crowd.internal.CrowdRealm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.security.role.RoleIdentifier;
import org.sonatype.nexus.security.user.AbstractUserManager;
import org.sonatype.nexus.security.user.User;
import org.sonatype.nexus.security.user.UserManager;
import org.sonatype.nexus.security.user.UserNotFoundException;
import org.sonatype.nexus.security.user.UserNotFoundTransientException;
import org.sonatype.nexus.security.user.UserSearchCriteria;
import org.sonatype.nexus.security.user.UserStatus;

@Named(value="Crowd")
@Typed(value={UserManager.class})
@Singleton
public class CrowdUserManager
extends AbstractUserManager {
    private static final String SOURCE = "Crowd";
    private static final Property<String> USERNAME = new PropertyImpl("name", String.class);
    private static final Property<String> EMAIL = new PropertyImpl("email", String.class);
    private final Crowd crowd;
    private final int maxSearchResults;

    @Inject
    public CrowdUserManager(Crowd crowd, @Named(value="${nexus.crowd.search.maxResults:-500}") int maxSearchResults) {
        this.crowd = (Crowd)Preconditions.checkNotNull((Object)crowd);
        this.maxSearchResults = maxSearchResults;
    }

    public String getAuthenticationRealmName() {
        return SOURCE;
    }

    public String getSource() {
        return SOURCE;
    }

    public boolean supportsWrite() {
        return true;
    }

    public User getUser(String userId) throws UserNotFoundException {
        try {
            return this.convertWithRoles(this.crowd.client().getUser(userId));
        }
        catch (com.atlassian.crowd.exception.UserNotFoundException e) {
            throw new UserNotFoundException(userId, e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            CrowdRealm.logWarning(this.log, "Unable to look up Crowd user " + userId, e);
            throw new UserNotFoundTransientException(userId, e.getMessage(), (Throwable)e);
        }
    }

    public User addUser(User user, String password) {
        try {
            this.crowd.client().addUser(this.convert(user), new PasswordCredential(password));
            for (RoleIdentifier roleIdentifier : user.getRoles()) {
                if (!roleIdentifier.getSource().equals(SOURCE)) continue;
                this.crowd.client().addUserToGroup(user.getUserId(), roleIdentifier.getRoleId());
            }
            return this.getUser(user.getUserId());
        }
        catch (Exception e) {
            CrowdRealm.logError(this.log, "Failed to create Crowd user " + user.getUserId(), e);
            throw new RuntimeException("Failed to create Crowd user " + user.getUserId(), e);
        }
    }

    public User updateUser(User user) throws UserNotFoundException {
        try {
            this.crowd.client().updateUser(this.convert(user));
            Set<RoleIdentifier> oldRoles = this.getRoles(user.getUserId());
            Set newRoles = Sets.filter((Set)user.getRoles(), (Predicate)new Predicate<RoleIdentifier>(){

                public boolean apply(@Nullable RoleIdentifier roleIdentifier) {
                    return roleIdentifier != null && CrowdUserManager.this.getSource().equals(roleIdentifier.getSource());
                }
            });
            for (RoleIdentifier roleIdentifier : Sets.difference(oldRoles, (Set)newRoles)) {
                this.crowd.client().removeUserFromGroup(user.getUserId(), roleIdentifier.getRoleId());
            }
            for (RoleIdentifier roleIdentifier : Sets.difference((Set)newRoles, oldRoles)) {
                this.crowd.client().addUserToGroup(user.getUserId(), roleIdentifier.getRoleId());
            }
            return this.getUser(user.getUserId());
        }
        catch (com.atlassian.crowd.exception.UserNotFoundException e) {
            throw new UserNotFoundException(user.getUserId(), e.getMessage(), (Throwable)e);
        }
        catch (OperationFailedException e) {
            CrowdRealm.logWarning(this.log, "Unable to update Crowd user " + user.getUserId(), e);
            throw new UserNotFoundTransientException(user.getUserId(), e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            CrowdRealm.logError(this.log, "Failed to update Crowd user " + user.getUserId(), e);
            throw new RuntimeException("Failed to update Crowd user " + user.getUserId(), e);
        }
    }

    public void deleteUser(String userId) throws UserNotFoundException {
        try {
            this.crowd.client().removeUser(userId);
        }
        catch (com.atlassian.crowd.exception.UserNotFoundException e) {
            throw new UserNotFoundException(userId, e.getMessage(), (Throwable)e);
        }
        catch (OperationFailedException e) {
            CrowdRealm.logWarning(this.log, "Unable to remove Crowd user " + userId, e);
            throw new UserNotFoundTransientException(userId, e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            CrowdRealm.logError(this.log, "Unable to remove Crowd user " + userId, e);
            throw new UserNotFoundException(userId, e.getMessage(), (Throwable)e);
        }
    }

    public void changePassword(String userId, String newPassword) throws UserNotFoundException {
        try {
            this.crowd.client().updateUserCredential(userId, newPassword);
        }
        catch (com.atlassian.crowd.exception.UserNotFoundException e) {
            throw new UserNotFoundException(userId, e.getMessage(), (Throwable)e);
        }
        catch (OperationFailedException e) {
            CrowdRealm.logWarning(this.log, "Unable to update credentials of Crowd user " + userId, e);
            throw new UserNotFoundTransientException(userId, e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            CrowdRealm.logError(this.log, "Failed to update credentials of user " + userId, e);
            throw new RuntimeException("Failed to update credentials of Crowd user " + userId, e);
        }
    }

    public Set<String> listUserIds() {
        try {
            return Sets.newHashSet((Iterable)this.crowd.client().searchUserNames(this.allUsers(), 0, Integer.MAX_VALUE));
        }
        catch (Exception e) {
            CrowdRealm.logWarning(this.log, "Failed to retrieve Crowd users", e);
            return Collections.emptySet();
        }
    }

    public Set<User> listUsers() {
        return this.searchUsers(this.allUsers(), false);
    }

    public Set<User> searchUsers(UserSearchCriteria criteria) {
        boolean fetchRoles;
        boolean bl = fetchRoles = criteria.getUserId() != null;
        if (criteria.getSource() != null && !this.getSource().equals(criteria.getSource())) {
            return Collections.emptySet();
        }
        return this.filterListInMemeory(this.searchUsers(this.asSearchRestriction(criteria), fetchRoles), criteria);
    }

    private Set<User> searchUsers(SearchRestriction restriction, final boolean fetchRoles) {
        try {
            return Sets.newHashSet((Iterable)Iterables.transform((Iterable)this.crowd.client().searchUsers(restriction, 0, this.maxSearchResults), (Function)new Function<com.atlassian.crowd.model.user.User, User>(){

                @Nullable
                public User apply(@Nullable com.atlassian.crowd.model.user.User input) {
                    if (input == null) {
                        return null;
                    }
                    return fetchRoles ? CrowdUserManager.this.convertWithRoles(input) : CrowdUserManager.this.convert(input);
                }
            }));
        }
        catch (Exception e) {
            CrowdRealm.logWarning(this.log, "Failed to retrieve Crowd users", e);
            return Collections.emptySet();
        }
    }

    private SearchRestriction allUsers() {
        return this.asSearchRestriction(null);
    }

    private SearchRestriction asSearchRestriction(UserSearchCriteria criteria) {
        ArrayList restrictions = Lists.newArrayList();
        if (criteria != null) {
            if (!Strings2.isEmpty((String)criteria.getUserId())) {
                restrictions.add(new TermRestriction(USERNAME, MatchMode.STARTS_WITH, (Object)criteria.getUserId()));
            }
            if (!Strings2.isEmpty((String)criteria.getEmail())) {
                restrictions.add(new TermRestriction(EMAIL, MatchMode.EXACTLY_MATCHES, (Object)criteria.getUserId()));
            }
        }
        if (restrictions.isEmpty()) {
            return NullRestrictionImpl.INSTANCE;
        }
        if (restrictions.size() == 1) {
            return (SearchRestriction)restrictions.get(0);
        }
        return Combine.allOf((Collection)restrictions);
    }

    private Set<RoleIdentifier> getRoles(String userId) {
        try {
            List groupsForUser = this.crowd.client().getNamesOfGroupsForNestedUser(userId, 0, Integer.MAX_VALUE);
            return Sets.newHashSet((Iterable)Iterables.transform((Iterable)groupsForUser, (Function)new Function<String, RoleIdentifier>(){

                public RoleIdentifier apply(String groupId) {
                    return new RoleIdentifier(CrowdUserManager.this.getSource(), groupId);
                }
            }));
        }
        catch (Exception e) {
            CrowdRealm.logWarning(this.log, "Unable to look roles for user " + userId, e);
            return Sets.newHashSet();
        }
    }

    private User convert(com.atlassian.crowd.model.user.User crowdUser) {
        User user = new User();
        user.setUserId(crowdUser.getName());
        user.setFirstName(crowdUser.getFirstName());
        user.setLastName(crowdUser.getLastName());
        user.setEmailAddress(crowdUser.getEmailAddress());
        user.setStatus(crowdUser.isActive() ? UserStatus.active : UserStatus.disabled);
        user.setSource(SOURCE);
        return user;
    }

    private User convertWithRoles(com.atlassian.crowd.model.user.User crowdUser) {
        User user = this.convert(crowdUser);
        user.setRoles(this.getRoles(user.getUserId()));
        return user;
    }

    private com.atlassian.crowd.model.user.User convert(User user) {
        return new UserEntity(user.getUserId(), user.getFirstName(), user.getLastName(), String.valueOf(user.getFirstName()) + " " + user.getLastName(), user.getEmailAddress(), null, user.getStatus().isActive());
    }
}

