/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.crowd.internal;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.security.config.CPrivilege;
import org.sonatype.nexus.security.config.MemorySecurityConfiguration;
import org.sonatype.nexus.security.config.SecurityConfiguration;
import org.sonatype.nexus.security.config.SecurityContributor;
import org.sonatype.nexus.security.config.SecurityContributorSupport;

@Named
@Singleton
public class CrowdSecurityContributor
extends SecurityContributorSupport
implements SecurityContributor {
    public static final String CROWD_DOMAIN = "crowd";
    public static final String CROWD_ALL_PRIV_ID = "nx-crowd-all";
    public static final String CROWD_UPDATE_PRIV_ID = "nx-crowd-update";
    public static final String CROWD_READ_PRIV_ID = "nx-crowd-read";

    public SecurityConfiguration getContribution() {
        MemorySecurityConfiguration config = new MemorySecurityConfiguration();
        config.addPrivilege((CPrivilege)this.createApplicationPrivilege(CROWD_ALL_PRIV_ID, "All permissions for " + StringUtils.capitalize((String)CROWD_DOMAIN), CROWD_DOMAIN, "*"));
        config.addPrivilege((CPrivilege)this.createApplicationPrivilege(CROWD_UPDATE_PRIV_ID, "Update permission for " + StringUtils.capitalize((String)CROWD_DOMAIN), CROWD_DOMAIN, "*"));
        config.addPrivilege((CPrivilege)this.createApplicationPrivilege(CROWD_READ_PRIV_ID, "Read permission for " + StringUtils.capitalize((String)CROWD_DOMAIN), CROWD_DOMAIN, "*"));
        return config;
    }
}

