/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.crowd.internal;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.crowd.CrowdConfiguration;
import com.sonatype.nexus.crowd.internal.CrowdConfigurationChangedEvent;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.common.event.EventAware;

@Named
@Singleton
public class CrowdConfigurationAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "security.crowd";

    @Subscribe
    @AllowConcurrentEvents
    public void on(CrowdConfigurationChangedEvent event) {
        if (this.isRecording()) {
            CrowdConfiguration configuration = event.getConfiguration();
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType("changed");
            data.setContext("system");
            Map attributes = data.getAttributes();
            attributes.put("applicationName", configuration.getApplicationName());
            attributes.put("serverUrl", configuration.getCrowdServerUrl());
            attributes.put("httpTimeout", CrowdConfigurationAuditor.string((Object)configuration.getHttpTimeout()));
            attributes.put("useTrustStore", CrowdConfigurationAuditor.string((Object)configuration.getUseTrustStore()));
            this.record(data);
        }
    }
}

